/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors.idproviders;

import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import java.util.HashMap;
import java.util.Map;

public final class ConsistentRetestIdProvider
implements RetestIdProvider {
    private final RetestIdProvider delegate;
    private final Map<String, String> consistency = new HashMap<String, String>();

    public ConsistentRetestIdProvider(RetestIdProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getRetestId(IdentifyingAttributes identifyingAttributes) {
        String result = this.consistency.get(identifyingAttributes.identifier());
        if (result != null) {
            return result;
        }
        result = this.delegate.getRetestId(identifyingAttributes);
        while (this.consistency.containsValue(result)) {
            result = this.delegate.getRetestId(identifyingAttributes);
        }
        this.consistency.put(identifyingAttributes.identifier(), result);
        return result;
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

