/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.RecheckProperties;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AlignmentPseudoElementHack;
import de.retest.recheck.ui.diff.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Alignment {
    private static final Logger log = LoggerFactory.getLogger(Alignment.class);
    static final double ELEMENT_MATCH_THRESHOLD = RecheckProperties.getInstance().elementMatchThreshold();
    private final Map<Element, Element> expectedChildParentMapping = new HashMap<Element, Element>();
    private final Map<Element, Element> actualChildParentMapping = new HashMap<Element, Element>();
    private final Map<Element, Element> alignment;
    AlignmentPseudoElementHack pseudoElementHack = new AlignmentPseudoElementHack();

    public static Alignment createAlignment(Element expected, Element actual) {
        return new Alignment(expected, actual);
    }

    private Alignment(Element expected, Element actual) {
        List<Element> expectedElements = Alignment.flattenLeafElements(expected, this.expectedChildParentMapping, this.pseudoElementHack.expectedPseudoElementsMapping);
        List<Element> actualElements = Alignment.flattenLeafElements(actual, this.actualChildParentMapping, this.pseudoElementHack.actualPseudoElementsMapping);
        log.debug("Creating assignment of old to new elements, trying to find differences. We are comparing {} with {} elements.", (Object)expectedElements.size(), (Object)actualElements.size());
        this.alignment = this.createAlignment(expectedElements, Alignment.toIdentityMapping(actualElements));
        this.addParentAlignment();
        this.pseudoElementHack.alignPseudoElements(this.alignment);
    }

    private static List<Element> flattenLeafElements(Element element, Map<Element, Element> childParentMapping, Map<Element, Element> pseudoElementsMapping) {
        ArrayList<Element> flattened = new ArrayList<Element>();
        for (Element childElement : element.getContainedElements()) {
            childParentMapping.put(childElement, element);
            if (AlignmentPseudoElementHack.isLeafAndPrepareMapping(childElement, pseudoElementsMapping)) {
                flattened.add(childElement);
                continue;
            }
            flattened.addAll(Alignment.flattenLeafElements(childElement, childParentMapping, pseudoElementsMapping));
        }
        return flattened;
    }

    private Map<Element, Element> createAlignment(List<Element> expectedElements, Map<Element, Element> actualElements) {
        Deque<Element> elementsToAlign = Alignment.toReverseDeque(expectedElements);
        HashMap<Element, Match> matches = new HashMap<Element, Match>();
        HashMap<Element, Element> alignment = new HashMap<Element, Element>();
        while (!elementsToAlign.isEmpty()) {
            Element expected = elementsToAlign.pollLast();
            NavigableSet<Match> bestMatches = Alignment.getBestMatches(expected, actualElements);
            Match bestMatch = bestMatches.pollFirst();
            while (bestMatch != null && matches.containsKey(bestMatch.element)) {
                Match previousMatch = (Match)matches.get(bestMatch.element);
                if (bestMatch.similarity <= previousMatch.similarity) {
                    bestMatch = bestMatches.pollFirst();
                    continue;
                }
                alignment.remove(previousMatch.element);
                elementsToAlign.add(previousMatch.element);
                break;
            }
            if (bestMatch == null) {
                alignment.put(expected, null);
                continue;
            }
            if (bestMatch.similarity < ELEMENT_MATCH_THRESHOLD) {
                log.debug("Best match {} is below threshold with {} similarity.", (Object)bestMatch.element, (Object)bestMatch.similarity);
                alignment.put(expected, null);
                continue;
            }
            alignment.put(expected, bestMatch.element);
            matches.put(bestMatch.element, Match.of(bestMatch.similarity, expected));
        }
        return alignment;
    }

    static Deque<Element> toReverseDeque(List<Element> expectedElements) {
        return expectedElements.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedList::new), deque -> {
            Collections.reverse(deque);
            return deque;
        }));
    }

    private static NavigableSet<Match> getBestMatches(Element expected, Map<Element, Element> actualElements) {
        if (actualElements.containsKey(expected)) {
            Element identityResult = actualElements.get(expected);
            Match bestMatch = Match.ofEqual(identityResult);
            return new TreeSet<Match>(Collections.singleton(bestMatch));
        }
        TreeSet<Match> bestMatches = new TreeSet<Match>();
        for (Element actual : actualElements.keySet()) {
            double similarity = Alignment.match(expected, actual);
            if (similarity == 1.0) {
                bestMatches.add(Match.ofEqual(actual));
                return bestMatches;
            }
            bestMatches.add(Match.of(similarity, actual));
        }
        return bestMatches;
    }

    private void addParentAlignment() {
        HashMap<Element, Element> alignmentCopy = new HashMap<Element, Element>(this.alignment);
        for (Map.Entry alignmentPair : alignmentCopy.entrySet()) {
            List<Element> expectedParents = this.getParents((Element)alignmentPair.getKey(), this.expectedChildParentMapping);
            List<Element> actualParents = this.getParents((Element)alignmentPair.getValue(), this.actualChildParentMapping);
            Map<Element, Element> parentAlignment = this.createAlignment(expectedParents, Alignment.toIdentityMapping(actualParents));
            for (Map.Entry<Element, Element> parentAlignmentPair : parentAlignment.entrySet()) {
                Element aligned = this.alignment.get(parentAlignmentPair.getKey());
                if (aligned == null) {
                    this.alignment.put(parentAlignmentPair.getKey(), parentAlignmentPair.getValue());
                    continue;
                }
                if (parentAlignmentPair.getValue() == null || !(Alignment.match(parentAlignmentPair.getKey(), parentAlignmentPair.getValue()) > Alignment.match(parentAlignmentPair.getKey(), aligned))) continue;
                this.alignment.put(parentAlignmentPair.getKey(), parentAlignmentPair.getValue());
            }
        }
    }

    private List<Element> getParents(Element element, Map<Element, Element> childParentMapping) {
        ArrayList<Element> parents = new ArrayList<Element>();
        Element parent = childParentMapping.get(element);
        while (parent != null) {
            parents.add(parent);
            parent = childParentMapping.get(parent);
        }
        return parents;
    }

    static Map<Element, Element> toIdentityMapping(List<Element> actualElements) {
        return actualElements.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    static double match(Element expected, Element bestMatch) {
        return expected.getIdentifyingAttributes().match(bestMatch.getIdentifyingAttributes());
    }

    public Element getActual(Element expected) {
        return this.alignment.get(expected);
    }

    public String toString() {
        return this.alignment.toString();
    }

    public int hashCode() {
        return this.alignment.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Alignment) {
            Alignment otherAlignment = (Alignment)other;
            return this.alignment.equals(otherAlignment.alignment);
        }
        return false;
    }
}

