/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.Alignment;
import de.retest.recheck.ui.diff.Match;
import java.util.HashMap;
import java.util.Map;

class AlignmentPseudoElementHack {
    final Map<Element, Element> expectedPseudoElementsMapping = new HashMap<Element, Element>();
    final Map<Element, Element> actualPseudoElementsMapping = new HashMap<Element, Element>();

    AlignmentPseudoElementHack() {
    }

    void alignPseudoElements(Map<Element, Element> alignment) {
        this.expectedPseudoElementsMapping.forEach((expectedPseudo, expectedParent) -> {
            Element actualParent = (Element)alignment.get(expectedParent);
            if (actualParent != null) {
                this.actualPseudoElementsMapping.entrySet().stream().filter(entry -> ((Element)entry.getValue()).equals(actualParent)).map(Map.Entry::getKey).map(actualPseudoCandidate -> AlignmentPseudoElementHack.match(expectedPseudo, actualPseudoCandidate)).filter(match -> match.similarity > Alignment.ELEMENT_MATCH_THRESHOLD).sorted().findFirst().ifPresent(m -> alignment.put((Element)expectedPseudo, m.element));
            }
        });
    }

    static boolean isLeafAndPrepareMapping(Element element, Map<Element, Element> pseudoElementsMapping) {
        boolean isLeaf = true;
        for (Element child : element.getContainedElements()) {
            if (AlignmentPseudoElementHack.isPseudoElement(child)) {
                pseudoElementsMapping.put(child, element);
                continue;
            }
            isLeaf = false;
        }
        return isLeaf;
    }

    private static boolean isPseudoElement(Element e) {
        return e.getIdentifyingAttributes().getType().startsWith("::");
    }

    private static Match match(Element expected, Element actualCandidate) {
        return Match.of(Alignment.match(expected, actualCandidate), actualCandidate);
    }
}

