/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.ElementIdentificationWarning;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.util.ChecksumCalculator;
import de.retest.recheck.util.ObjectUtil;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AttributeDifference
implements LeafDifference,
Comparable<AttributeDifference>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AttributeDifference.class);
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String key;
    @XmlAttribute
    private final String attributeDifferenceId;
    @XmlElement
    private final Object expected;
    @XmlElement
    private final Object actual;
    @XmlElement
    private final List<ElementIdentificationWarning> elementIdentificationWarnings;

    protected AttributeDifference() {
        this.key = null;
        this.expected = null;
        this.actual = null;
        this.attributeDifferenceId = null;
        this.elementIdentificationWarnings = new ArrayList<ElementIdentificationWarning>();
    }

    public AttributeDifference(String key, Serializable expected, Serializable actual) {
        this.key = key;
        this.expected = expected;
        this.actual = actual;
        this.attributeDifferenceId = this.identifier();
        this.elementIdentificationWarnings = new ArrayList<ElementIdentificationWarning>();
    }

    public String getKey() {
        return this.key;
    }

    public List<ElementIdentificationWarning> getElementIdentificationWarnings() {
        return this.elementIdentificationWarnings;
    }

    public void addElementIdentificationWarning(ElementIdentificationWarning elementIdentificationWarning) {
        this.elementIdentificationWarnings.add(elementIdentificationWarning);
    }

    public void addElementIdentificationWarnings(Collection<? extends ElementIdentificationWarning> warnings) {
        this.elementIdentificationWarnings.addAll(warnings);
    }

    public boolean hasElementIdentificationWarning() {
        return !this.elementIdentificationWarnings.isEmpty();
    }

    @Override
    public Serializable getExpected() {
        return (Serializable)this.expected;
    }

    @Override
    public Serializable getActual() {
        return (Serializable)this.actual;
    }

    public String getExpectedToString() {
        return Objects.toString(this.expected);
    }

    public String getActualToString() {
        return Objects.toString(this.actual);
    }

    public String identifier() {
        String contents = Stream.of(this.key, this.actual, this.expected).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(" # "));
        return ChecksumCalculator.getInstance().sha256(contents);
    }

    public Attribute applyChangeTo(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Cannot apply change to an attribute that is null.");
        }
        this.warnIfAttributesDontMatch(attribute.getValue());
        return attribute.applyChanges(this.getActual());
    }

    protected final void warnIfAttributesDontMatch(Serializable fromAttribute) {
        Serializable expected = this.getExpected();
        if (ObjectUtil.isNullOrEmptyString(fromAttribute) ? ObjectUtil.isNullOrEmptyString(expected) : Objects.equals(fromAttribute, expected)) {
            return;
        }
        logger.warn("Mismatch for attribute '{}': value from Golden Master '{}', value from test report '{}'. This could be due to a change in between.", new Object[]{this.key, fromAttribute, expected});
    }

    @Override
    public int compareTo(AttributeDifference other) {
        if (other == null) {
            return 1;
        }
        int result = ObjectUtil.compare(0, (Serializable)((Object)this.key), (Serializable)((Object)other.getKey()));
        result = ObjectUtil.compare(result, (Serializable)this.expected, other.getExpected());
        return ObjectUtil.compare(result, (Serializable)this.actual, other.getActual());
    }

    @Override
    public String toString() {
        return this.key + ": expected=\"" + this.expected + "\", actual=\"" + this.actual + "\"";
    }

    public static String getSumIdentifier(List<AttributeDifference> attributeDifferences) {
        StringBuilder result = new StringBuilder();
        for (AttributeDifference attributeDifference : attributeDifferences) {
            result.append(" # ").append(attributeDifference.identifier());
        }
        return ChecksumCalculator.getInstance().sha256(result.toString());
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return Collections.emptyList();
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeDifference)) {
            return false;
        }
        AttributeDifference other = (AttributeDifference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$attributeDifferenceId = this.attributeDifferenceId;
        String other$attributeDifferenceId = other.attributeDifferenceId;
        if (this$attributeDifferenceId == null ? other$attributeDifferenceId != null : !this$attributeDifferenceId.equals(other$attributeDifferenceId)) {
            return false;
        }
        Serializable this$expected = this.getExpected();
        Serializable other$expected = other.getExpected();
        if (this$expected == null ? other$expected != null : !this$expected.equals(other$expected)) {
            return false;
        }
        Serializable this$actual = this.getActual();
        Serializable other$actual = other.getActual();
        if (this$actual == null ? other$actual != null : !this$actual.equals(other$actual)) {
            return false;
        }
        List<ElementIdentificationWarning> this$elementIdentificationWarnings = this.getElementIdentificationWarnings();
        List<ElementIdentificationWarning> other$elementIdentificationWarnings = other.getElementIdentificationWarnings();
        return !(this$elementIdentificationWarnings == null ? other$elementIdentificationWarnings != null : !((Object)this$elementIdentificationWarnings).equals(other$elementIdentificationWarnings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeDifference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $attributeDifferenceId = this.attributeDifferenceId;
        result = result * 59 + ($attributeDifferenceId == null ? 43 : $attributeDifferenceId.hashCode());
        Serializable $expected = this.getExpected();
        result = result * 59 + ($expected == null ? 43 : $expected.hashCode());
        Serializable $actual = this.getActual();
        result = result * 59 + ($actual == null ? 43 : $actual.hashCode());
        List<ElementIdentificationWarning> $elementIdentificationWarnings = this.getElementIdentificationWarnings();
        result = result * 59 + ($elementIdentificationWarnings == null ? 43 : ((Object)$elementIdentificationWarnings).hashCode());
        return result;
    }
}

