/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ignore.GloballyIgnoredAttributes;
import de.retest.recheck.image.ImageDiffCalcFactory;
import de.retest.recheck.image.ImageDifference;
import de.retest.recheck.image.ImageDifferenceCalculator;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.ScreenshotAttributeDifference;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ListMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class AttributesDifferenceFinder {
    private final DefaultValueFinder defaultValueFinder;
    private static final ImageDifferenceCalculator imgDiffCalc = ImageDiffCalcFactory.getConfiguredImageDifferenceCalculator();

    public AttributesDifferenceFinder(DefaultValueFinder defaultValueFinder) {
        this.defaultValueFinder = defaultValueFinder;
    }

    public AttributesDifference differenceFor(Element expected, Element actual) {
        IdentifyingAttributes identAttributes = expected.getIdentifyingAttributes();
        Attributes expectedCrit = expected.getAttributes();
        Attributes actualCrit = actual.getAttributes();
        ArrayList<AttributeDifference> differences = new ArrayList<AttributeDifference>();
        ListMap<String, ? extends Serializable> unshownRightMap = new ListMap<String, Serializable>(actualCrit.getMap());
        for (Map.Entry<String, ? extends Serializable> entry : expectedCrit.getMap().entrySet()) {
            AttributeDifference attributeDifference = this.differenceFor(identAttributes, entry.getValue(), (Serializable)actualCrit.get(entry.getKey()), entry.getKey());
            if (attributeDifference != null) {
                differences.add(attributeDifference);
            }
            unshownRightMap.remove(entry.getKey());
        }
        for (Map.Entry<String, Serializable> entry : unshownRightMap.entrySet()) {
            AttributeDifference optionalDifference = this.differenceFor(identAttributes, (Serializable)expectedCrit.get(entry.getKey()), entry.getValue(), entry.getKey());
            if (optionalDifference == null) continue;
            differences.add(optionalDifference);
        }
        return differences.isEmpty() ? null : new AttributesDifference(differences);
    }

    private AttributeDifference differenceFor(IdentifyingAttributes identAttributes, Serializable expected, Serializable actual, String key) {
        if (GloballyIgnoredAttributes.getInstance().shouldIgnoreAttribute(key) || Objects.equals(expected, actual) || !AttributesDifferenceFinder.deleted(expected, actual) && this.defaultValueFinder.isDefaultValue(identAttributes, key, actual)) {
            return null;
        }
        if ("screenshot".equals(key)) {
            Screenshot expectedScreenshot = (Screenshot)expected;
            Screenshot actualScreenshot = (Screenshot)actual;
            ImageDifference imgDiff = imgDiffCalc.compare(expectedScreenshot, actualScreenshot);
            if (imgDiff.isEqual()) {
                return null;
            }
            return new ScreenshotAttributeDifference(expectedScreenshot, actualScreenshot, imgDiff.getStrategyName(), imgDiff.getMatch());
        }
        return new AttributeDifference(key, expected, actual);
    }

    private static boolean deleted(Serializable expected, Serializable actual) {
        return expected != null && actual == null;
    }
}

