/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.persistence.xml.XmlTransformer;
import de.retest.recheck.ui.descriptors.AttributeUtil;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ChecksumCalculator;
import jakarta.xml.bind.Marshaller;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ElementDifference
implements Difference,
Comparable<ElementDifference> {
    protected static final long serialVersionUID = 2L;
    protected final AttributesDifference attributesDifference;
    protected final LeafDifference identifyingAttributesDifference;
    protected Collection<ElementDifference> childDifferences = new ArrayList<ElementDifference>();
    protected final Screenshot expectedScreenshot;
    protected final Screenshot actualScreenshot;
    private Element element;

    public ElementDifference(Element element, AttributesDifference attributesDifference, LeafDifference identifyingAttributesDifference, Screenshot expectedScreenshot, Screenshot actualScreenshot, Collection<ElementDifference> childDifferences) {
        this.element = element;
        this.attributesDifference = attributesDifference;
        this.identifyingAttributesDifference = identifyingAttributesDifference;
        this.expectedScreenshot = expectedScreenshot;
        this.actualScreenshot = actualScreenshot;
        this.childDifferences.addAll(childDifferences);
    }

    public Screenshot mark(Screenshot screenshot) {
        if (screenshot == null) {
            return null;
        }
        ArrayList<Rectangle> marks = new ArrayList<Rectangle>();
        if (this.childDifferences != null) {
            for (Difference difference : this.childDifferences) {
                for (ElementDifference compDiff : difference.getNonEmptyDifferences()) {
                    marks.add(AttributeUtil.getAbsoluteOutline(compDiff.getIdentifyingAttributes()));
                }
            }
        }
        return ImageUtils.image2Screenshot(screenshot.getPersistenceId(), ImageUtils.mark(ImageUtils.screenshot2Image(screenshot), marks));
    }

    public static ElementDifference getCopyWithFlattenedChildDifferenceHierarchy(ElementDifference elementDifference) {
        ElementDifference result = elementDifference;
        while (result.childDifferences.size() == 1 && result.identifyingAttributesDifference == null && result.attributesDifference == null) {
            result = result.childDifferences.iterator().next();
        }
        return result;
    }

    public Collection<ElementDifference> getChildDifferences() {
        return Collections.unmodifiableCollection(this.childDifferences);
    }

    public List<Difference> getImmediateDifferences() {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (this.identifyingAttributesDifference != null) {
            differences.add(this.identifyingAttributesDifference);
        }
        if (this.attributesDifference != null) {
            differences.add(this.attributesDifference);
        }
        return differences;
    }

    public List<AttributeDifference> getAttributeDifferences() {
        ArrayList<AttributeDifference> differences = new ArrayList<AttributeDifference>();
        if (this.identifyingAttributesDifference instanceof IdentifyingAttributesDifference) {
            IdentifyingAttributesDifference identifyingAttributesDifference = (IdentifyingAttributesDifference)this.identifyingAttributesDifference;
            differences.addAll(identifyingAttributesDifference.getAttributeDifferences());
        }
        if (this.attributesDifference != null) {
            differences.addAll(this.attributesDifference.getDifferences());
        }
        return differences;
    }

    public String getIdentifier() {
        StringBuilder result = new StringBuilder().append(this.getIdentifyingAttributes().identifier());
        if (this.identifyingAttributesDifference != null) {
            result.append(ElementDifference.getSumIdentifier(this.identifyingAttributesDifference.getNonEmptyDifferences()));
        }
        if (this.attributesDifference != null) {
            result.append(this.attributesDifference.getIdentifier());
        }
        return ChecksumCalculator.getInstance().sha256(result.toString());
    }

    private static String getSumIdentifier(Collection<ElementDifference> differences) {
        return differences.stream().map(ElementDifference::getIdentifier).collect(Collectors.collectingAndThen(Collectors.joining(" # "), ChecksumCalculator.getInstance()::sha256));
    }

    public boolean hasAttributesDifferences() {
        return this.attributesDifference != null && this.attributesDifference.size() > 0;
    }

    public boolean hasIdentAttributesDifferences() {
        return this.identifyingAttributesDifference instanceof IdentifyingAttributesDifference;
    }

    public boolean isInsertionOrDeletion() {
        return this.identifyingAttributesDifference instanceof InsertedDeletedElementDifference;
    }

    public boolean hasChildDifferences() {
        return !this.childDifferences.isEmpty();
    }

    public boolean isInsertion() {
        return this.isInsertionOrDeletion() && ((InsertedDeletedElementDifference)this.identifyingAttributesDifference).isInserted();
    }

    public boolean isDeletion() {
        return this.isInsertionOrDeletion() && !((InsertedDeletedElementDifference)this.identifyingAttributesDifference).isInserted();
    }

    public boolean hasAnyDifference() {
        return this.hasAttributesDifferences() || this.hasIdentAttributesDifferences() || this.isInsertionOrDeletion();
    }

    @Override
    public int size() {
        if (this.identifyingAttributesDifference != null || this.attributesDifference != null) {
            return 1;
        }
        if (this.hasChildDifferences()) {
            int size = 0;
            for (Difference difference : this.childDifferences) {
                size += difference.size();
            }
            return size;
        }
        return 0;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        if (this.identifyingAttributesDifference != null || this.attributesDifference != null) {
            result.add(this);
        }
        for (Difference difference : this.childDifferences) {
            result.addAll(difference.getNonEmptyDifferences());
        }
        return result;
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        ArrayList<ElementDifference> differences = new ArrayList<ElementDifference>();
        differences.add(this);
        for (ElementDifference childDifference : this.childDifferences) {
            differences.addAll(childDifference.getElementDifferences());
        }
        return differences;
    }

    @Override
    public String toString() {
        if (this.identifyingAttributesDifference != null) {
            return this.getIdentifyingAttributes().toString() + ":\n at: " + this.getIdentifyingAttributes().getPath() + ":\n\t" + this.identifyingAttributesDifference;
        }
        if (this.attributesDifference != null) {
            String differences = this.attributesDifference.getDifferences().stream().map(Object::toString).collect(Collectors.joining("\n\t"));
            return this.getIdentifyingAttributes().toString() + ":\n at: " + this.getIdentifyingAttributes().getPath() + ":\n\t" + differences;
        }
        if (this.hasChildDifferences()) {
            if (this.size() > 50) {
                Difference difference;
                StringBuilder result = new StringBuilder();
                Iterator<ElementDifference> diffIter = this.childDifferences.iterator();
                for (int diffCnt = 0; diffCnt < 50 && diffIter.hasNext(); diffCnt += difference.size()) {
                    difference = diffIter.next();
                    result.append(difference.toString() + ", ");
                }
                return result.substring(0, result.length() - 2);
            }
            return this.childDifferences.toString();
        }
        return "noDifferences: " + this.getIdentifyingAttributes().toString();
    }

    @Override
    public int compareTo(ElementDifference other) {
        if (this.getIdentifyingAttributes() == null || other.getIdentifyingAttributes() == null) {
            throw new IllegalStateException("Identifying attributes may not be null. Loaded lightweight XML?");
        }
        return this.getIdentifyingAttributes().compareTo(other.getIdentifyingAttributes());
    }

    protected ElementDifference() {
        this.attributesDifference = null;
        this.identifyingAttributesDifference = null;
        this.expectedScreenshot = null;
        this.actualScreenshot = null;
    }

    void beforeMarshal(Marshaller m) {
        if (XmlTransformer.isLightweightMarshaller(m) && this.identifyingAttributesDifference == null && this.attributesDifference == null) {
            List<ElementDifference> childDifferences = this.getClippedNonEmptyChildren();
            childDifferences.remove(this);
            this.childDifferences = childDifferences;
        }
    }

    private List<ElementDifference> getClippedNonEmptyChildren() {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        if (this.identifyingAttributesDifference != null || this.attributesDifference != null) {
            result.add(this);
        } else {
            for (ElementDifference childDifference : this.childDifferences) {
                result.addAll(childDifference.getClippedNonEmptyChildren());
            }
        }
        return result;
    }

    public IdentifyingAttributes getIdentifyingAttributes() {
        return this.element.getIdentifyingAttributes();
    }

    public String getRetestId() {
        return this.element.getRetestId();
    }

    public AttributesDifference getAttributesDifference() {
        return this.attributesDifference;
    }

    public LeafDifference getIdentifyingAttributesDifference() {
        return this.identifyingAttributesDifference;
    }

    public Screenshot getExpectedScreenshot() {
        return this.expectedScreenshot;
    }

    public Screenshot getActualScreenshot() {
        return this.actualScreenshot;
    }

    public Element getElement() {
        return this.element;
    }

    public String getElementToString() {
        return Objects.toString(this.element);
    }
}

