/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdentifyingAttributesDifference
implements LeafDifference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String differenceId;
    @XmlElement(name="attribute")
    private final List<Attribute> attributes;
    @XmlElement(name="attributeDifference")
    private final List<AttributeDifference> attributeDifferences;

    private IdentifyingAttributesDifference() {
        this.differenceId = null;
        this.attributes = null;
        this.attributeDifferences = null;
    }

    public IdentifyingAttributesDifference(IdentifyingAttributes expectedIdentAttributes, List<AttributeDifference> attributeDifferences) {
        this.attributes = expectedIdentAttributes.getAttributes();
        this.attributeDifferences = attributeDifferences;
        this.differenceId = AttributeDifference.getSumIdentifier(attributeDifferences);
    }

    @Override
    public String toString() {
        StringBuilder expectedDiff = new StringBuilder();
        StringBuilder actualDiff = new StringBuilder();
        for (AttributeDifference attributeDifference : this.attributeDifferences) {
            expectedDiff.append(" expected ").append(attributeDifference.getKey()).append(": ").append(attributeDifference.getExpected());
            actualDiff.append(" actual ").append(attributeDifference.getKey()).append(": ").append(attributeDifference.getActual());
        }
        return expectedDiff.toString().trim() + " - " + actualDiff.toString().trim();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return Collections.emptyList();
    }

    @Override
    public Serializable getActual() {
        return this.attributeDifferences.stream().map(attributeDifference -> attributeDifference.getKey() + "=" + attributeDifference.getActual()).collect(Collectors.joining(" ")).toString().trim();
    }

    @Override
    public Serializable getExpected() {
        return this.attributeDifferences.stream().map(attributeDifference -> attributeDifference.getKey() + "=" + attributeDifference.getExpected()).collect(Collectors.joining(" ")).toString().trim();
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return Collections.emptyList();
    }

    public List<AttributeDifference> getAttributeDifferences() {
        return this.attributeDifferences;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentifyingAttributesDifference)) {
            return false;
        }
        IdentifyingAttributesDifference other = (IdentifyingAttributesDifference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$differenceId = this.differenceId;
        String other$differenceId = other.differenceId;
        if (this$differenceId == null ? other$differenceId != null : !this$differenceId.equals(other$differenceId)) {
            return false;
        }
        List<Attribute> this$attributes = this.attributes;
        List<Attribute> other$attributes = other.attributes;
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<AttributeDifference> this$attributeDifferences = this.getAttributeDifferences();
        List<AttributeDifference> other$attributeDifferences = other.getAttributeDifferences();
        return !(this$attributeDifferences == null ? other$attributeDifferences != null : !((Object)this$attributeDifferences).equals(other$attributeDifferences));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdentifyingAttributesDifference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $differenceId = this.differenceId;
        result = result * 59 + ($differenceId == null ? 43 : $differenceId.hashCode());
        List<Attribute> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<AttributeDifference> $attributeDifferences = this.getAttributeDifferences();
        result = result * 59 + ($attributeDifferences == null ? 43 : ((Object)$attributeDifferences).hashCode());
        return result;
    }
}

