/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ignore.GloballyIgnoredAttributes;
import de.retest.recheck.ui.descriptors.AdditionalAttributeDifference;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IdentifyingAttributesDifferenceFinder {
    public IdentifyingAttributesDifference differenceFor(IdentifyingAttributes expected, IdentifyingAttributes actual) {
        return this.differenceFor(expected, actual, GloballyIgnoredAttributes.getInstance());
    }

    IdentifyingAttributesDifference differenceFor(IdentifyingAttributes expected, IdentifyingAttributes actual, GloballyIgnoredAttributes ignored) {
        Objects.requireNonNull(expected, "Expected cannot be null!");
        Objects.requireNonNull(actual, "Actual cannot be null!");
        ArrayList<AttributeDifference> attributeDifferences = new ArrayList<AttributeDifference>();
        List<Attribute> expectedAttributes = expected.getAttributes();
        for (Attribute expectedAttr : expectedAttributes) {
            String key = expectedAttr.getKey();
            Serializable expectedValue = expectedAttr.getValue();
            Serializable actualValue = (Serializable)actual.get(key);
            if (expectedAttr.isNotVisible() || ignored.shouldIgnoreAttribute(key)) continue;
            if ("path".equals(key)) {
                if (!IdentifyingAttributesDifferenceFinder.pathDiffers(expected, actual)) continue;
                attributeDifferences.add(new AttributeDifference(key, (Serializable)((Object)expected.getPath()), (Serializable)((Object)actual.getPath())));
                continue;
            }
            if (!IdentifyingAttributesDifferenceFinder.differs(expectedValue, actualValue)) continue;
            attributeDifferences.add(new AttributeDifference(key, expectedValue, actualValue));
        }
        actual.getAttributes().stream().filter(actualAttr -> expected.getAttribute(actualAttr.getKey()) == null).map(additionalAttr -> new AdditionalAttributeDifference(additionalAttr.getKey(), (Attribute)additionalAttr)).forEach(attributeDifferences::add);
        return attributeDifferences.isEmpty() ? null : new IdentifyingAttributesDifference(expected, attributeDifferences);
    }

    private static boolean pathDiffers(IdentifyingAttributes expected, IdentifyingAttributes actual) {
        return !expected.getPathElement().equals(actual.getPathElement());
    }

    private static boolean differs(Object expected, Object actual) {
        return ObjectUtil.isNullOrEmptyString(expected) ? !ObjectUtil.isNullOrEmptyString(actual) : !expected.equals(actual);
    }
}

