/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.RecheckProperties;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.ElementUtil;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.ElementDifferenceFinder;
import de.retest.recheck.ui.diff.RootElementDifference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootElementDifferenceFinder {
    private static final Logger logger = LoggerFactory.getLogger(RootElementDifferenceFinder.class);
    private static final double ROOT_ELEMENT_MATCH_THRESHOLD = RecheckProperties.getInstance().rootElementMatchThreshold();
    private static final double ROOT_ELEMENT_CONTAINED_CHILDREN_MATCH_THRESHOLD = RecheckProperties.getInstance().rootElementContainedChildrenMatchThreshold();
    private final ElementDifferenceFinder elementDifferenceFinder;

    public RootElementDifferenceFinder(DefaultValueFinder defaultValueFinder) {
        this.elementDifferenceFinder = new ElementDifferenceFinder(defaultValueFinder);
    }

    public List<RootElementDifference> findDifferences(List<RootElement> expecteds, List<RootElement> actuals) {
        ArrayList<RootElementDifference> differences = new ArrayList<RootElementDifference>();
        ArrayList<RootElement> copyOfActuals = new ArrayList<RootElement>(actuals);
        for (RootElement expected : expecteds) {
            RootElementDifference difference = this.findDifference(expected, this.findAndRemove(expected, copyOfActuals));
            if (difference == null) continue;
            differences.add(difference);
        }
        for (RootElement actual : copyOfActuals) {
            differences.add(this.findDifference(null, actual));
        }
        return differences;
    }

    private RootElement findAndRemove(RootElement expected, List<RootElement> actuals) {
        double bestMatch = 0.0;
        RootElement bestWindow = null;
        for (RootElement actual : actuals) {
            if (actual.getIdentifyingAttributes().equals(expected.getIdentifyingAttributes())) {
                bestMatch = 1.0;
                bestWindow = actual;
                break;
            }
            double currentMatch = actual.getIdentifyingAttributes().match(expected.getIdentifyingAttributes());
            if (!(currentMatch > bestMatch)) continue;
            bestMatch = currentMatch;
            bestWindow = actual;
        }
        if (bestWindow == null) {
            logger.info("No window at all found!");
            return null;
        }
        if (bestMatch >= ROOT_ELEMENT_MATCH_THRESHOLD) {
            actuals.remove(bestWindow);
            return bestWindow;
        }
        logger.info("Best match of window {} did not exceed MATCH_THRESHOLD with {}: {}", new Object[]{expected.getIdentifyingAttributes(), bestMatch, bestWindow});
        double containedComponentsMatch = this.compareContainedComponents(expected, bestWindow);
        if (containedComponentsMatch >= ROOT_ELEMENT_CONTAINED_CHILDREN_MATCH_THRESHOLD) {
            logger.info("Best match of window has a match of contained components of {}.", (Object)containedComponentsMatch);
            return bestWindow;
        }
        return null;
    }

    private double compareContainedComponents(RootElement expected, RootElement bestWindow) {
        return (double)this.getNumberOfChildDifferences(expected, bestWindow) / ((double)this.getNumberOfChildComponents(expected, bestWindow) + 1.0);
    }

    private int getNumberOfChildDifferences(RootElement expected, RootElement bestWindow) {
        Collection<ElementDifference> differences = this.elementDifferenceFinder.findChildDifferences(expected, bestWindow);
        int count = 0;
        for (ElementDifference elementDifference : differences) {
            count += elementDifference.getImmediateDifferences().size();
        }
        logger.debug("Found {} child differences for window {} and best match {}.", new Object[]{count, expected, bestWindow});
        return count;
    }

    private int getNumberOfChildComponents(RootElement expected, RootElement bestWindow) {
        int expectedChildCount = ElementUtil.flattenChildElements(expected).size();
        int bestWindowChildCount = ElementUtil.flattenChildElements(bestWindow).size();
        logger.debug("Window {} contained {} components, and and best match {} contained {} components.", new Object[]{expected, expectedChildCount, bestWindow, bestWindowChildCount});
        return Math.max(expectedChildCount, bestWindowChildCount);
    }

    public RootElementDifference findDifference(RootElement expected, RootElement actual) {
        long startTime = System.currentTimeMillis();
        ElementDifference elementDifference = this.elementDifferenceFinder.differenceFor(expected, actual);
        logger.debug("Finding differences for window took {}ms.", (Object)(System.currentTimeMillis() - startTime));
        return elementDifference != null ? new RootElementDifference(elementDifference, expected, actual) : null;
    }
}

