/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.ElementDifferenceFinder;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ChecksumCalculator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StateDifference
implements Difference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String differenceId;
    @XmlAnyElement(lax=true)
    private final List<RootElementDifference> differences;

    private StateDifference() {
        this.differenceId = null;
        this.differences = new ArrayList<RootElementDifference>();
    }

    public StateDifference(List<RootElementDifference> differences) {
        this.differenceId = StateDifference.getSumIdentifier(differences);
        this.differences = differences;
    }

    @Override
    public String toString() {
        return this.differences.toString();
    }

    @Override
    public int size() {
        int size = 0;
        for (Difference difference : this.differences) {
            size += difference.size();
        }
        return size;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return ElementDifferenceFinder.getNonEmptyDifferences(this.differences);
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return ElementDifferenceFinder.getElementDifferences(this.differences);
    }

    public String getIdentifier() {
        return this.differenceId;
    }

    public List<RootElementDifference> getRootElementDifferences() {
        return this.differences;
    }

    public List<Screenshot> getExpectedScreenshots() {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        for (RootElementDifference rootElementDifference : this.differences) {
            result.add(rootElementDifference.getExpectedScreenshot());
        }
        return result;
    }

    public List<Screenshot> getActualScreenshots() {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        for (RootElementDifference rootElementDifference : this.differences) {
            result.add(rootElementDifference.getActualScreenshot());
        }
        return result;
    }

    private static String getSumIdentifier(List<RootElementDifference> differences) {
        return differences.stream().map(RootElementDifference::getIdentifier).collect(Collectors.collectingAndThen(Collectors.joining(" # "), ChecksumCalculator.getInstance()::sha256));
    }
}

