/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff.meta;

import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.meta.MetadataDifference;
import de.retest.recheck.ui.diff.meta.MetadataElementDifference;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetadataDifferenceFinder {
    public MetadataDifference findDifferences(SutState expected, SutState actual) {
        return this.findDifferences(expected.getMetadata(), actual.getMetadata());
    }

    private MetadataDifference findDifferences(Map<String, String> expected, Map<String, String> actual) {
        return this.collectAllKeys(expected, actual).map(key -> this.differenceFor((String)key, (String)expected.get(key), (String)actual.get(key))).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), MetadataDifference::of));
    }

    private Stream<String> collectAllKeys(Map<String, String> expected, Map<String, String> actual) {
        return Stream.of(expected.keySet(), actual.keySet()).flatMap(Collection::stream).distinct();
    }

    private MetadataElementDifference differenceFor(String key, String expected, String actual) {
        return Objects.equals(expected, actual) ? null : new MetadataElementDifference(key, expected, actual);
    }
}

