/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.image;

import de.retest.recheck.util.ChecksumCalculator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Screenshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private final String persistenceId;
    @XmlTransient
    private byte[] binaryData;
    @XmlTransient
    private transient String sha256;
    @XmlElement
    private final ImageType type;

    private Screenshot() {
        this.persistenceId = null;
        this.binaryData = null;
        this.type = null;
    }

    public Screenshot(String persistenceId, byte[] binaryData, ImageType type) {
        if (binaryData == null) {
            throw new NullPointerException("binaryData must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null.");
        }
        this.binaryData = binaryData;
        this.type = type;
        this.persistenceId = persistenceId;
        this.ensureSha();
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
        this.sha256 = null;
        this.ensureSha();
    }

    public ImageType getType() {
        return this.type;
    }

    public String getPersistenceId() {
        return this.persistenceId;
    }

    public int hashCode() {
        this.ensureSha();
        return this.type.hashCode() + (this.persistenceId.hashCode() * 31 + this.sha256.hashCode()) * 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Screenshot)) {
            return false;
        }
        Screenshot other = (Screenshot)obj;
        if (this.type != other.type || !this.persistenceId.equals(other.persistenceId)) {
            return false;
        }
        this.ensureSha();
        other.ensureSha();
        return this.sha256.equals(other.sha256);
    }

    private void ensureSha() {
        this.sha256 = this.binaryData != null ? ChecksumCalculator.getInstance().sha256(this.binaryData) : "";
    }

    public String toString() {
        return "Screenshot of " + this.persistenceId;
    }

    public static enum ImageType {
        PNG;


        public String getFileExtension() {
            return this.name().toLowerCase();
        }
    }
}

