/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.review;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.review.AttributeChanges;
import de.retest.recheck.ui.review.ScreenshotChanges;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionChangeSet {
    private final String description;
    private final String goldenMasterPath;
    private final ScreenshotChanges screenshots;
    private final Map<String, String> metadata;
    private final AttributeChanges identAttributeChanges = new AttributeChanges();
    private final AttributeChanges attributeChanges = new AttributeChanges();
    private final Set<Element> insertChanges = new HashSet<Element>();
    private final Set<IdentifyingAttributes> deletedChanges = new HashSet<IdentifyingAttributes>();

    public ActionChangeSet() {
        this(null, null, ScreenshotChanges.empty(), Collections.emptyMap());
    }

    public ActionChangeSet(String description, String goldenMasterPath, ScreenshotChanges screenshots) {
        this(description, goldenMasterPath, screenshots, Collections.emptyMap());
    }

    public ActionChangeSet(String description, String goldenMasterPath, ScreenshotChanges screenshots, Map<String, String> metadata) {
        this.description = description;
        this.goldenMasterPath = goldenMasterPath;
        this.screenshots = screenshots;
        this.metadata = metadata;
    }

    public AttributeChanges getIdentAttributeChanges() {
        return this.identAttributeChanges;
    }

    public AttributeChanges getAttributesChanges() {
        return this.attributeChanges;
    }

    public List<AttributeChanges> getAllAttributeChanges() {
        return Arrays.asList(this.identAttributeChanges, this.attributeChanges);
    }

    public boolean containsInsertChange(Element element) {
        return this.insertChanges.contains(element);
    }

    public void addInsertChange(Element element) {
        this.insertChanges.add(element);
    }

    public void removeInsertChange(Element element) {
        this.insertChanges.remove(element);
    }

    public Set<Element> getInsertedChanges() {
        return Collections.unmodifiableSet(this.insertChanges);
    }

    public boolean containsDeletedChange(IdentifyingAttributes identifyingAttributes) {
        return this.deletedChanges.contains(identifyingAttributes);
    }

    public void addDeletedChange(IdentifyingAttributes identifyingAttributes) {
        this.deletedChanges.add(identifyingAttributes);
    }

    public void removeDeletedChange(IdentifyingAttributes identifyingAttributes) {
        this.deletedChanges.remove(identifyingAttributes);
    }

    public Set<IdentifyingAttributes> getDeletedChanges() {
        return Collections.unmodifiableSet(this.deletedChanges);
    }

    public boolean isEmpty() {
        return this.identAttributeChanges.isEmpty() && this.attributeChanges.isEmpty() && this.insertChanges.isEmpty() && this.deletedChanges.isEmpty();
    }

    private int size() {
        return this.identAttributeChanges.size() + this.attributeChanges.size() + this.insertChanges.size() + this.deletedChanges.size();
    }

    public String toString() {
        return "ActionChangeSet [" + this.size() + " changes]";
    }

    public String getDescription() {
        return this.description;
    }

    public String getGoldenMasterPath() {
        return this.goldenMasterPath;
    }

    public ScreenshotChanges getScreenshot() {
        return this.screenshots;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }
}

