/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.review;

import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.GoldenMasterSource;
import de.retest.recheck.ui.review.SuiteChangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ReviewResult {
    private final ArrayList<SuiteChangeSet> suiteChangeSets = new ArrayList();

    public SuiteChangeSet createSuiteChangeSet(String suiteName, String uuid) {
        return this.createSuiteChangeSet(suiteName, uuid, GoldenMasterSource.RECORDED);
    }

    public SuiteChangeSet createSuiteChangeSet(String suiteName, String uuid, GoldenMasterSource source) {
        SuiteChangeSet suiteChangeSet = new SuiteChangeSet(suiteName, uuid, source);
        this.suiteChangeSets.add(suiteChangeSet);
        return suiteChangeSet;
    }

    public List<SuiteChangeSet> getSuiteChangeSets() {
        ArrayList<SuiteChangeSet> nonEmpyChangeSets = new ArrayList<SuiteChangeSet>();
        for (SuiteChangeSet suiteChangeSet : this.suiteChangeSets) {
            if (suiteChangeSet.isEmpty()) continue;
            nonEmpyChangeSets.add(suiteChangeSet);
        }
        return nonEmpyChangeSets;
    }

    public List<ActionChangeSet> getAllActionChangeSets() {
        return this.getSuiteChangeSets().stream().flatMap(suiteChangeSet -> suiteChangeSet.getTestChangeSets().stream()).flatMap(testChangeSet -> testChangeSet.getAllActionChangeSets().stream()).collect(Collectors.toList());
    }

    public List<AttributeDifference> getAllAttributeDifferences() {
        return this.getAllActionChangeSets().stream().flatMap(actionChangeSet -> actionChangeSet.getAllAttributeChanges().stream()).flatMap(attributeChanges -> attributeChanges.getChanges().values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        return "ReviewResult [suiteChangeSets=" + this.suiteChangeSets.size() + "]";
    }
}

