/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.review;

import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.StateDifference;
import de.retest.recheck.ui.image.Screenshot;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ScreenshotChanges {
    private static final ScreenshotChanges EMPTY_SCREENSHOTS = new ScreenshotChanges(Collections.emptyMap());
    private final Map<IdentifyingAttributes, Screenshot> screenshotMap;

    public static ScreenshotChanges empty() {
        return EMPTY_SCREENSHOTS;
    }

    public static ScreenshotChanges actual(ActionReplayResult result) {
        StateDifference stateDifference = result.getStateDifference();
        if (stateDifference == null) {
            return EMPTY_SCREENSHOTS;
        }
        return new ScreenshotChanges(stateDifference.getRootElementDifferences().stream().filter(ScreenshotChanges.actualScreenshotNotNull()).map(RootElementDifference::getElementDifference).collect(Collectors.toMap(ElementDifference::getIdentifyingAttributes, ElementDifference::getActualScreenshot)));
    }

    private static Predicate<RootElementDifference> actualScreenshotNotNull() {
        return difference -> difference.getActualScreenshot() != null;
    }

    public Screenshot getScreenshot(IdentifyingAttributes attribute) {
        return this.screenshotMap.get(attribute);
    }

    private ScreenshotChanges(Map<IdentifyingAttributes, Screenshot> screenshotMap) {
        this.screenshotMap = screenshotMap;
    }
}

