/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOnCloseFileInputStream
extends FileInputStream {
    private static final Logger log = LoggerFactory.getLogger(DeleteOnCloseFileInputStream.class);
    private final File file;

    public DeleteOnCloseFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.file.exists()) {
                FileUtils.forceDelete((File)this.file);
            } else {
                log.debug("File '{}' has already been deleted.", (Object)this.file);
            }
        }
    }
}

