/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.ui.actions.ExceptionWrapper;
import de.retest.recheck.util.StackTraceParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExceptionUtil {
    private static final Pattern excNamePattern = Pattern.compile("([\\w\\/.]+Exception|Error)");
    private static final String STACKTRACE_START_PATTERN = "\tat ";
    private static final String CAUSE_START_PATTERN = "Caused by: ";

    public static String getStackTrace(Throwable exc) {
        if (exc == null) {
            return "";
        }
        StringWriter errors = new StringWriter();
        exc.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static List<String> getStackTraceAsList(Throwable exc) {
        ArrayList<String> result = new ArrayList<String>();
        for (StackTraceElement element : exc.getStackTrace()) {
            result.add(element.toString());
        }
        return result;
    }

    public static Throwable getDeepestCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable.getCause() != null) {
            return ExceptionUtil.getDeepestCause(throwable.getCause());
        }
        return throwable;
    }

    public static ExceptionWrapper reconstructThrowableFromLog(String text) {
        if (!text.contains("Exception") && !text.contains("Error")) {
            return null;
        }
        String deepestCause = ExceptionUtil.clipToDeepestCause(text);
        Matcher matcher = excNamePattern.matcher(deepestCause);
        if (!matcher.find()) {
            return null;
        }
        String type = matcher.group(1);
        String[] stack = deepestCause.split("\n");
        String errorMsg = stack[0].replace(type, "");
        if (errorMsg.startsWith(CAUSE_START_PATTERN)) {
            errorMsg = errorMsg.replace(CAUSE_START_PATTERN, "");
        }
        if (errorMsg.startsWith(": ")) {
            errorMsg = errorMsg.replace(": ", "");
        }
        return new ExceptionWrapper(type, text, errorMsg, stack.length > 1 ? stack[1].replace(STACKTRACE_START_PATTERN, "") : null);
    }

    public static Throwable reconstructThrowableFromWrapper(ExceptionWrapper error) {
        Throwable result = ExceptionUtil.reconstructInstance(error.getType(), error.getMessage());
        if (result == null) {
            result = new RuntimeException(error.getType() + ": " + error.getMessage());
        }
        result.setStackTrace(ExceptionUtil.reconstructStackTrace(error.getStackTrace()));
        return result;
    }

    protected static StackTraceElement[] reconstructStackTrace(String stackTrace) {
        if (stackTrace == null) {
            return new StackTraceElement[0];
        }
        return StackTraceParser.parseStackTrace(stackTrace);
    }

    protected static Throwable reconstructInstance(String type, String msg) {
        if (type == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(type);
            try {
                return (Throwable)clazz.getConstructor(String.class).newInstance(msg);
            }
            catch (Exception exc) {
                return (Throwable)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String clipToDeepestCause(String text) {
        if (!text.contains(CAUSE_START_PATTERN)) {
            return text;
        }
        return text.substring(text.lastIndexOf(CAUSE_START_PATTERN));
    }

    public static boolean containsError(String text) {
        if (!text.contains("Exception") && !text.contains("Error")) {
            return false;
        }
        Matcher matcher = excNamePattern.matcher(text);
        return matcher.find();
    }

    public static boolean isPartOfPrintStackTrace(String msg) {
        return msg.contains(STACKTRACE_START_PATTERN) || msg.contains(CAUSE_START_PATTERN);
    }

    public static <T> T getExceptionInChain(Throwable exc, Class<T> clazz) {
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!clazz.isAssignableFrom(cause.getClass())) continue;
            return (T)cause;
        }
        return null;
    }

    public static boolean hasExceptionInChain(Throwable exc, Class<?> clazz) {
        return ExceptionUtil.getExceptionInChain(exc, clazz) != null;
    }

    public static String getDeepestStackTraceElement(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace == null) {
            return null;
        }
        return stackTrace[0].toString();
    }

    public static List<String> getExceptionStackTraceCompletely(Throwable t) {
        ArrayList<String> stackTrace = new ArrayList<String>();
        stackTrace.add(t.toString());
        Arrays.stream(t.getStackTrace()).map(ste -> STACKTRACE_START_PATTERN + ste).forEach(stackTrace::add);
        Throwable cause = t.getCause();
        if (cause != null) {
            List<String> stackTraceCause = ExceptionUtil.getExceptionStackTraceCompletely(cause);
            stackTraceCause.set(0, CAUSE_START_PATTERN + stackTraceCause.get(0));
            stackTrace.addAll(stackTraceCause);
        }
        return stackTrace;
    }
}

