/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.ioerror.ReTestLoadException;
import de.retest.recheck.ioerror.ReTestSaveException;
import de.retest.recheck.util.GetRelativeFilePath;
import de.retest.recheck.util.NamedBufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final FileFilter PNG_FILTER = file -> file.getName().endsWith(".png");

    public static String readFileToString(File source) {
        if (source == null) {
            return "";
        }
        try {
            return FileUtils.readFileToString((File)source, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static String canonicalPathQuietly(File file) {
        try {
            if (file != null) {
                return file.getCanonicalPath();
            }
            return "null";
        }
        catch (IOException exc) {
            String result = file.getAbsolutePath();
            logger.error("Exception getting canonical path for file '{}'.", (Object)result, (Object)exc);
            return result;
        }
    }

    public static File canonicalFileQuietly(File file) {
        try {
            if (file != null) {
                return file.getCanonicalFile();
            }
        }
        catch (IOException exc) {
            logger.error("Exception getting canonical file for file '{}'.", (Object)file.getPath(), (Object)exc);
        }
        return file;
    }

    public static void deleteRecursively(File file) {
        FileUtils.deleteQuietly((File)file);
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            FileUtils.copyDirectory((File)from, (File)to, (boolean)true);
            return;
        }
        FileUtils.copyFile((File)from, (File)to, (boolean)true);
    }

    public static List<File> listFilesRecursively(File folder, FileFilter filter) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("'" + folder + "' is not a directory!");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = folder.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            if (filter.accept(file)) {
                result.add(file);
            }
            if (!file.isDirectory()) continue;
            result.addAll(FileUtil.listFilesRecursively(file, filter));
        }
        return result;
    }

    public static List<File> listFilesRecursively(File folder, FilenameFilter filter) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("'" + folder + "' is not a directory!");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = folder.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            if (filter.accept(file, file.getName())) {
                result.add(file);
            }
            if (!file.isDirectory()) continue;
            result.addAll(FileUtil.listFilesRecursively(file, filter));
        }
        return result;
    }

    public static List<File> listFilesRecursively(File folder, javax.swing.filechooser.FileFilter filter) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("'" + folder + "' is not a directory!");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = folder.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            if (filter.accept(file)) {
                result.add(file);
            }
            if (!file.isDirectory()) continue;
            result.addAll(FileUtil.listFilesRecursively(file, filter));
        }
        return result;
    }

    public static String normalize(String text) {
        return text.replaceAll("[%\\.\"\\*/:<>\\?\\\\\\|\\+,\\.;=\\[\\]]", "_").trim();
    }

    public static void ensureFolder(File result) throws ReTestSaveException {
        if (result.getParent() != null) {
            new File(result.getParent()).mkdirs();
            return;
        }
        try {
            result.getCanonicalFile().getParentFile().mkdirs();
        }
        catch (IOException exc) {
            logger.error("Exception creating parent folder of file '{}'.", (Object)result, (Object)exc);
            throw new ReTestSaveException(result.getAbsoluteFile().toURI(), "Exception creating parent folder.", exc);
        }
    }

    public static List<File> convertNames2Files(File baseDir, String[] fileNames) {
        ArrayList<File> result = new ArrayList<File>();
        for (String fileName : fileNames) {
            result.add(new File(baseDir, fileName));
        }
        return result;
    }

    public static List<File> convertSemicolonSeparatedString2ListOfFiles(File baseDir, String fileList) throws IOException {
        String[] files;
        ArrayList<File> result = new ArrayList<File>();
        if (fileList == null || fileList.trim().isEmpty()) {
            return result;
        }
        for (String fileName : files = fileList.split(";")) {
            if (fileName.trim().isEmpty()) continue;
            File file = new File(baseDir, fileName);
            if (!file.exists()) {
                throw new IOException("File '" + FileUtil.canonicalPathQuietly(file) + "' does not exist!");
            }
            result.add(file);
        }
        return result;
    }

    public static String convertListOfFiles2SemicolonJoinedString(File baseDir, List<File> files) throws IOException {
        String result = "";
        if (files == null || files.isEmpty()) {
            return result;
        }
        for (File file : files) {
            result = result + GetRelativeFilePath.getRelativeFilePath(baseDir, file) + ";";
        }
        return result.substring(0, result.length() - 1);
    }

    public static URL toUrl(File file) throws IOException {
        try {
            return new URL("file:" + file.getCanonicalPath());
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void writeToFile(File file, Writer writer) throws IOException {
        FileOutputStream out = null;
        try {
            FileUtil.ensureFolder(file);
            out = new FileOutputStream(file);
            writer.write(out);
        }
        catch (Exception e) {
            throw new ReTestSaveException(file.getAbsoluteFile().toURI(), (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryWriteToFile(File file, Writer writer) {
        FileOutputStream out = null;
        try {
            file.getParentFile().mkdirs();
            out = new FileOutputStream(file);
            writer.write(out);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Error writing to file '{}', ignoring: {}", (Object)file, (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readFromFile(File file, Reader<T> reader) throws IOException {
        try (NamedBufferedInputStream in = new NamedBufferedInputStream((InputStream)new FileInputStream(file), file.getName());){
            T t = reader.read(in);
            return t;
        }
        catch (Exception e) {
            throw new ReTestLoadException(file.toURI(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T tryReadFromFile(File file, Reader<T> reader) {
        try (NamedBufferedInputStream in = new NamedBufferedInputStream((InputStream)new FileInputStream(file), file.getName());){
            T t = reader.read(in);
            return t;
        }
        catch (IOException e) {
            logger.warn("Error reading from file '{}', ignoring: {}", (Object)FileUtil.canonicalPathQuietly(file), (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T readFromZipFile(File file, ZipReader<T> reader) throws IOException {
        ZipFile in = null;
        try {
            in = new ZipFile(file);
            T t = reader.read(in);
            return t;
        }
        catch (Exception e) {
            throw new ReTestLoadException(file.toURI(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Exception closing input stream for zip file '{}'.", (Object)file, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T tryReadFromZipFile(File file, ZipReader<T> reader) {
        if (!file.exists()) {
            logger.error("File '{}' does not exist!", (Object)FileUtil.canonicalPathQuietly(file));
            return null;
        }
        ZipFile in = null;
        try {
            in = new ZipFile(file);
            T t = reader.read(in);
            return t;
        }
        catch (IllegalArgumentException exc) {
            logger.warn("Error reading from file with wrong XML-version: '{}'", (Object)FileUtil.canonicalPathQuietly(file), (Object)exc);
            throw exc;
        }
        catch (Exception e) {
            logger.warn("Error reading from file '{}', ignoring: ", (Object)FileUtil.canonicalPathQuietly(file), (Object)e);
            T t = null;
            return t;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Exception closing input stream for file '{}'.", (Object)file, (Object)e);
                }
            }
        }
    }

    public static String removeExtension(String fileName) {
        if (fileName.lastIndexOf(46) == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static String removeRelativePathExtension(File rootDir, File file) {
        return FileUtil.removeExtension(GetRelativeFilePath.getRelativeFilePathSilently(rootDir, file));
    }

    /*
     * Loose catch block
     */
    public static double getFileSizeInMB(File report) {
        double d;
        Throwable throwable;
        FileInputStream stream;
        block14: {
            block15: {
                stream = new FileInputStream(report);
                throwable = null;
                d = (double)((InputStream)stream).available() / 1024.0 / 1024.0;
                if (stream == null) break block14;
                if (throwable == null) break block15;
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block14;
            }
            ((InputStream)stream).close();
        }
        return d;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)stream).close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (IOException e) {
                logger.warn("Exception getting file length of file '{}'.", (Object)FileUtil.canonicalPathQuietly(report), (Object)e);
                return -1.0;
            }
        }
    }

    public static NamedBufferedInputStream getInputStreamFrom(File baseDir, String input) throws IOException {
        try {
            URL url = new URL(input);
            return new NamedBufferedInputStream(url.openStream(), input);
        }
        catch (IOException url) {
            File result = new File(baseDir, input).getCanonicalFile();
            if (result.exists()) {
                return new NamedBufferedInputStream((InputStream)new FileInputStream(result), input);
            }
            result = new File(input);
            if (result.exists()) {
                return new NamedBufferedInputStream((InputStream)new FileInputStream(result), input);
            }
            throw new IOException("Could not open file or URL with " + input);
        }
    }

    public static String cleanForFilename(String desc) {
        String result = desc;
        result = result.replace(' ', '_');
        result = result.replace('\n', '-');
        result = result.replace('\t', '-');
        result = result.replaceAll(System.getProperty("line.separator"), "-");
        result = result.replace(':', '-');
        result = result.replace('/', '-');
        return result.replace('\\', '-');
    }

    public static File readableCanonicalFileOrNull(File file) {
        if (file != null && file.exists() && file.canRead()) {
            return FileUtil.canonicalFileQuietly(file);
        }
        return null;
    }

    public static File readableWriteableCanonicalDirectoryOrNull(File directory) {
        File canonicalDir = FileUtil.canonicalFileQuietly(directory);
        if (canonicalDir != null && canonicalDir.exists() && FileUtil.canAll(canonicalDir) || !canonicalDir.exists() && FileUtil.canAll(canonicalDir.getParentFile())) {
            return canonicalDir;
        }
        return null;
    }

    private static boolean canAll(File file) {
        return file.canRead() && file.canWrite() && file.canExecute();
    }

    public static interface ZipReader<T> {
        public T read(ZipFile var1) throws IOException;
    }

    public static interface Reader<T> {
        public T read(NamedBufferedInputStream var1) throws IOException;
    }

    public static interface Writer {
        public void write(FileOutputStream var1) throws IOException;
    }
}

