/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class GetRelativeFilePath {
    public static final String TEST_FILE_SEPARATOR = "/";

    public static String getRelativeFilePath(String basePath, File file) throws IOException {
        return GetRelativeFilePath.getRelativeFilePath(file.getCanonicalFile(), new File(basePath));
    }

    public static String getRelativeFilePath(File baseFile, File file) throws IOException {
        String bpath = baseFile.getCanonicalPath();
        String fpath = file.getCanonicalPath();
        if (fpath.startsWith(bpath)) {
            int length = bpath.length();
            if (length == fpath.length()) {
                return ".";
            }
            return fpath.substring(length + 1);
        }
        File parent = baseFile.getParentFile();
        if (parent == null) {
            throw new IOException("No common directory");
        }
        return FileUtil.canonicalPathQuietly(file);
    }

    public static File fromRelativePath(File rootDir, String file) {
        return new File(rootDir, file);
    }

    public static String getRelativeFilePathSilently(File baseFile, File file) {
        try {
            return GetRelativeFilePath.getRelativeFilePath(baseFile, file);
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }
}

