/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.util.ListSet;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ListMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<Pair<K, V>> mappings = new ArrayList();

    public ListMap() {
    }

    public ListMap(Map<? extends K, ? extends V> otherMap) {
        this.putAll(otherMap);
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    @Override
    public boolean containsKey(Object k1) {
        for (Pair<K, V> mapping : this.mappings) {
            Object k2 = mapping.getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v1) {
        for (Pair<K, V> mapping : this.mappings) {
            Object v2 = mapping.getValue();
            if ((v1 != null || v2 != null) && (v2 == null || !v2.equals(v1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object k1) {
        for (Pair<K, V> mapping : this.mappings) {
            Object k2 = mapping.getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            return (V)mapping.getValue();
        }
        return null;
    }

    @Override
    public V put(K k1, V value) {
        for (Pair<K, V> mapping : this.mappings) {
            Object k2 = mapping.getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            Object result = mapping.getValue();
            mapping.setValue(value);
            return (V)result;
        }
        this.mappings.add(Pair.of(k1, value));
        return null;
    }

    @Override
    public V remove(Object k1) {
        for (int idx = 0; idx < this.mappings.size(); ++idx) {
            Pair<K, V> mapping = this.mappings.get(idx);
            Object k2 = mapping.getKey();
            if ((k1 != null || k2 != null) && (k2 == null || !k2.equals(k1))) continue;
            this.mappings.remove(idx);
            return (V)mapping.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mappings.clear();
    }

    @Override
    public Set<K> keySet() {
        ListSet<Object> result = new ListSet<Object>();
        for (Pair<K, V> mapping : this.mappings) {
            result.add(mapping.getKey());
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair<K, V> mapping : this.mappings) {
            result.add(mapping.getValue());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ListSet<Map.Entry<K, V>> result = new ListSet<Map.Entry<K, V>>();
        for (Pair<K, V> mapping : this.mappings) {
            result.add((Map.Entry<K, V>)Pair.of((Object)mapping.getKey(), (Object)mapping.getValue()));
        }
        return result;
    }
}

