/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtilities {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtilities.class);

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (!clazz.equals(Object.class)) {
            result.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        Class<?> currentClass = clazz;
        while (field == null && !currentClass.equals(Object.class)) {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException exc) {
                currentClass = currentClass.getSuperclass();
            }
        }
        if (field == null) {
            throw new RuntimeException(new NoSuchFieldException("Field '" + fieldName + "' not found in class '" + clazz + "' or any superclass"));
        }
        field.setAccessible(true);
        return field;
    }

    public static Class<?> getClassOrNull(String className) {
        try {
            return ReflectionUtilities.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    public static boolean instanceOf(String instanceClassName, Class<?> clazz) {
        try {
            Class<?> instanceClass = ReflectionUtilities.class.getClassLoader().loadClass(instanceClassName);
            return ReflectionUtilities.instanceOf(instanceClass, clazz.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("Couldn't find class '{}'.", (Object)instanceClassName, (Object)e);
            return false;
        }
    }

    public static boolean instanceOf(Class<?> instanceClass, String className) {
        if (className.startsWith("class ")) {
            throw new IllegalArgumentException("Class name starts with 'class '. This is probably due to the use of Object#toString(), whereas Class#getName() should be used.");
        }
        if (instanceClass.getName().equals(className)) {
            return true;
        }
        while (instanceClass.getSuperclass() != null) {
            if (!(instanceClass = instanceClass.getSuperclass()).getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static <T> T createNewInstanceOrNull(Class<T> assignableType, String className) {
        try {
            Class<T> targetClass = ReflectionUtilities.getSubClassOrNull(assignableType, className);
            if (targetClass == null) {
                return null;
            }
            return ReflectionUtilities.getNonArgConstructor(targetClass).newInstance(new Object[0]);
        }
        catch (InstantiationException exc) {
            throw new IllegalArgumentException("Can't create instance of an abstract class!", exc);
        }
        catch (InvocationTargetException exc) {
            throw new RuntimeException("Instance creation failed, constructor throws an exception!", exc);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("This shouldn't happen because the method is set accessible before!", exc);
        }
    }

    public static <T> Class<T> getSubClassOrNull(Class<T> clazz, String className) {
        Class<?> uncheckedClass = ReflectionUtilities.getClassOrNull(className);
        if (uncheckedClass != null && clazz.isAssignableFrom(uncheckedClass)) {
            return uncheckedClass;
        }
        return null;
    }

    public static <T> Constructor<T> getNonArgConstructor(Class<T> clazz) {
        return ReflectionUtilities.getConstructor(clazz, new Class[0]);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... classes) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalArgumentException("Class has no non-arg constructor!", exc);
        }
    }

    public static boolean hasMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static <T> T invokeMethod(Object callee, String methodName, Class<?>[] argClasses, Object[] args) {
        try {
            try {
                Method method = callee.getClass().getDeclaredMethod(methodName, argClasses);
                method.setAccessible(true);
                return (T)method.invoke(callee, args);
            }
            catch (NoSuchMethodException exc) {
                Method method = callee.getClass().getMethod(methodName, argClasses);
                return (T)method.invoke(callee, args);
            }
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static <T> T invokeMethod(Object callee, String methodName, Object ... params) {
        Class[] paramClasses = new Class[params.length];
        for (int index = 0; index < params.length; ++index) {
            paramClasses[index] = params[index].getClass();
        }
        T result = ReflectionUtilities.invokeMethod(callee, methodName, paramClasses, params);
        return result;
    }

    public static boolean isThreadDeathWhileClosingSuT(Throwable e) {
        if (e instanceof ThreadDeath) {
            for (StackTraceElement stackElement : e.getStackTrace()) {
                if (!"sun.awt.AppContext".equals(stackElement.getClassName()) || !"dispose".equals(stackElement.getMethodName())) continue;
                return true;
            }
        }
        if (e.getCause() != null) {
            return ReflectionUtilities.isThreadDeathWhileClosingSuT(e.getCause());
        }
        return false;
    }

    public static void setChildInParentToNull(Object parent, Object child) {
        for (Field field : ReflectionUtilities.getAllFields(parent.getClass())) {
            try {
                field.setAccessible(true);
                if (field.get(parent) != child) continue;
                field.set(parent, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)"Should not be possible!");
            }
        }
    }

    public static String getSimpleName(String classname) {
        if (classname == null || !classname.contains(".")) {
            return classname;
        }
        return classname.substring(classname.lastIndexOf(".") + 1);
    }

    public static class IncompatibleTypesException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IncompatibleTypesException(Class<?> expectedType, Class<?> actualType, String context) {
            super("Incompatible types: expected a value of type " + expectedType + " but was " + actualType + " " + context);
        }
    }
}

