/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.idproviders.DefaultRetestIdProvider;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.recheck.util.RetestIdUtil;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetestIdProviderUtil {
    private static final Logger logger = LoggerFactory.getLogger(RetestIdProviderUtil.class);
    private static RetestIdProvider configured;

    public static RetestIdProvider getConfiguredRetestIdProvider() {
        if (configured == null || Boolean.getBoolean("de.retest.Development")) {
            configured = RetestIdProviderUtil.createConfigured();
        }
        return configured;
    }

    protected static RetestIdProvider createConfigured() {
        String configuredClassName = System.getProperty("de.retest.retestIdProvider");
        if (!StringUtils.isBlank((CharSequence)configuredClassName)) {
            try {
                Class<?> configuredClass = Class.forName(configuredClassName);
                return (RetestIdProvider)configuredClass.newInstance();
            }
            catch (Exception e) {
                logger.error("Error instantiating configured retest ID provider '{}' (with property '{}'), falling back to default.", new Object[]{configuredClassName, "de.retest.retestIdProvider", e});
            }
        }
        return new DefaultRetestIdProvider();
    }

    static String getRetestId(RetestIdProvider idProvider, IdentifyingAttributes identifyingAttributes) {
        String retestId = idProvider.getRetestId(identifyingAttributes);
        if (RetestIdUtil.isValid(retestId)) {
            return retestId;
        }
        logger.debug("Invalid retest ID '{}' from '{}', using a random UUID as fallback.", (Object)retestId, (Object)idProvider.getClass().getName());
        return UUID.randomUUID().toString();
    }
}

