/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.List;

public class ThreadUtil {
    public static String getShortInfo(ThreadInfo threadInfo) {
        return "'" + threadInfo.getThreadName() + "' (" + (Object)((Object)threadInfo.getThreadState()) + ") in method '" + ThreadUtil.getBottomStack(threadInfo) + "'";
    }

    public static String getBottomStack(ThreadInfo threadInfo) {
        if (threadInfo.getStackTrace().length > 0) {
            return threadInfo.getStackTrace()[0].toString();
        }
        return "";
    }

    public static String getShortInfo(List<ThreadInfo> activeThreads) {
        String result = "";
        if (activeThreads.isEmpty()) {
            return result;
        }
        for (ThreadInfo threadInfo : activeThreads) {
            result = result + ThreadUtil.getShortInfo(threadInfo) + ", ";
        }
        return result.substring(0, result.length() - 2);
    }

    public static ThreadInfo[] getAllThreadInfos() {
        return ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
    }

    public static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder result = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace) {
            result.append("\n\tat ").append(stackTraceElement.toString());
        }
        return result.toString();
    }

    public static boolean stackTraceContainsClass(String classInCurrentThread) {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().equals(classInCurrentThread)) continue;
            return true;
        }
        return false;
    }
}

