/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui;

import de.retest.ui.PathElement;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Path
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PATH_SEPARATOR = "/";
    @XmlElement
    private final Path parentPath;
    @XmlElement
    private final PathElement element;
    @XmlTransient
    private String toStringCache;
    private static final Map<String, Path> paths = new HashMap<String, Path>();

    private Path() {
        this.parentPath = null;
        this.element = null;
    }

    private Path(PathElement element) {
        this(null, element);
    }

    private Path(Path parentPath, PathElement element) {
        this.parentPath = parentPath;
        this.element = element;
    }

    public Path getParentPath() {
        return this.parentPath;
    }

    public PathElement getElement() {
        return this.element;
    }

    public String toString() {
        if (this.toStringCache == null) {
            String parentPathTemp = this.parentPath == null ? "" : this.parentPath.toString() + PATH_SEPARATOR;
            this.toStringCache = parentPathTemp + (this.element == null ? "" : this.element.toString());
        }
        return this.toStringCache;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.parentPath == null ? 0 : this.parentPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
            return false;
        }
        return !(this.parentPath == null ? other.parentPath != null : !this.parentPath.equals(other.parentPath));
    }

    public boolean isParent(Path path) {
        return this.isParent(path.toString());
    }

    public boolean isParent(String path) {
        return path.startsWith(this.toString());
    }

    public static Path fromString(String path) {
        while (path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        if (!path.contains(PATH_SEPARATOR)) {
            return Path.path(PathElement.fromString(path));
        }
        Path result = null;
        while (path.contains(PATH_SEPARATOR)) {
            String pathElement = path.substring(0, path.indexOf(PATH_SEPARATOR));
            result = Path.path(result, PathElement.fromString(pathElement));
            path = path.substring(path.indexOf(PATH_SEPARATOR) + 1);
        }
        if (path.isEmpty()) {
            return result;
        }
        return Path.path(result, PathElement.fromString(path));
    }

    public static Path path(PathElement element) {
        Path result = paths.get(element.toString());
        if (result == null) {
            result = new Path(element);
            paths.put(element.toString(), result);
        }
        return result;
    }

    public static Path path(Path parentPath, PathElement element) {
        Path temp = new Path(parentPath, element);
        Path result = paths.get(temp.toString());
        if (result == null) {
            result = temp;
            paths.put(temp.toString(), result);
        }
        return result;
    }
}

