/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.persistence.DateAdapter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GroundState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_EXECUTION_DATE = "de.retest.execution.Date";
    public static final String PROPERTY_EXECUTION_SEED = "de.retest.execution.randomSeed";
    public static final String UNSPECIFIED = "unspecified SUT version";
    private final transient SimpleDateFormat xmlDateFormat = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss:SSS");
    @XmlElement
    protected final String sutVersion;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    protected final Date executionDate;
    @XmlElement
    protected final long randomSeed;

    public GroundState() {
        this(UNSPECIFIED);
    }

    public GroundState(String sutVersion) {
        this.sutVersion = sutVersion;
        this.executionDate = this.getDateProperty();
        this.randomSeed = this.getRandomSeedProperty();
    }

    private long getRandomSeedProperty() {
        String property = System.getProperty(PROPERTY_EXECUTION_SEED);
        if (property == null) {
            long result = 1L;
            System.setProperty(PROPERTY_EXECUTION_SEED, Long.toString(1L));
            return 1L;
        }
        return Long.parseLong(property);
    }

    private Date getDateProperty() {
        String property = System.getProperty(PROPERTY_EXECUTION_DATE);
        if (property == null) {
            Date result = new Date();
            System.setProperty(PROPERTY_EXECUTION_DATE, this.xmlDateFormat.format(result));
            return result;
        }
        try {
            return this.xmlDateFormat.parse(property);
        }
        catch (ParseException exc) {
            throw new RuntimeException("Exception parsing date '" + property + "'.", exc);
        }
    }

    public GroundState(String sutVersion, Date executionDate, long randomSeed) {
        this.sutVersion = sutVersion;
        this.executionDate = executionDate;
        this.randomSeed = randomSeed;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.executionDate == null ? 0 : this.executionDate.hashCode());
        result = 31 * result + (int)(this.randomSeed ^ this.randomSeed >>> 32);
        result = 31 * result + (this.sutVersion == null ? 0 : this.sutVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroundState other = (GroundState)obj;
        if (this.executionDate == null ? other.executionDate != null : !this.executionDate.equals(other.executionDate)) {
            return false;
        }
        if (this.randomSeed != other.randomSeed) {
            return false;
        }
        return !(this.sutVersion == null ? other.sutVersion != null : !this.sutVersion.equals(other.sutVersion));
    }

    public String toString() {
        String date = this.xmlDateFormat.format(this.executionDate);
        return "GroundState[sutVersion=" + this.sutVersion + ", executionDate=" + date + ", randomSeed=" + this.randomSeed + "l]";
    }

    public String getSutVersion() {
        return this.sutVersion;
    }
}

