/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.ui.descriptors.Attribute;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class OutlineAttribute
extends Attribute {
    public static final String RELATIVE_OUTLINE = "outline";
    public static final String ABSOLUTE_OUTLINE = "absolute-outline";
    private static final long serialVersionUID = 1L;
    public static final int MAX_HEIGHT = Integer.MAX_VALUE;
    public static final int MAX_WIDHT = Integer.MAX_VALUE;
    @XmlElement
    private final int x;
    @XmlElement
    private final int y;
    @XmlElement
    private final int height;
    @XmlElement
    private final int width;

    private OutlineAttribute() {
        this.x = -1;
        this.y = -1;
        this.height = -1;
        this.width = -1;
    }

    private OutlineAttribute(String relation, Rectangle outline) {
        super(relation);
        this.x = outline == null ? -1 : outline.x;
        this.y = outline == null ? -1 : outline.y;
        this.height = outline == null ? -1 : outline.height;
        this.width = outline == null ? -1 : outline.width;
    }

    public static OutlineAttribute createAbsolute(Rectangle outline) {
        return new OutlineAttribute(ABSOLUTE_OUTLINE, outline);
    }

    public static OutlineAttribute create(Rectangle outline) {
        return new OutlineAttribute(RELATIVE_OUTLINE, outline);
    }

    @Override
    public Rectangle getValue() {
        if (this.x == -1 && this.y == -1 && this.height == -1 && this.width == -1) {
            return null;
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public double getWeight() {
        return RELATIVE_OUTLINE.equals(this.getKey()) ? 1.0 : 0.0;
    }

    @Override
    public double match(Attribute other) {
        if (!(other instanceof OutlineAttribute)) {
            return 0.0;
        }
        OutlineAttribute outline = (OutlineAttribute)other;
        double result = 0.0;
        result += this.match(this.x, outline.x, Integer.MAX_VALUE) / 4.0;
        result += this.match(this.y, outline.y, Integer.MAX_VALUE) / 4.0;
        result += this.match(this.width, outline.width, Integer.MAX_VALUE) / 4.0;
        assert ((result += this.match(this.height, outline.height, Integer.MAX_VALUE) / 4.0) >= 0.0);
        assert (result <= 1.0);
        return result;
    }

    private double match(int value1, int value2, int maxDiff) {
        if (value1 == value2) {
            return 1.0;
        }
        return (double)Math.abs(value1 - value2) / (double)maxDiff;
    }

    public static Rectangle parse(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            Pattern pattern = Pattern.compile("java\\.awt\\.Rectangle\\[x=([\\- 0-9]+),y=([\\- 0-9]+),width=([\\- 0-9]+),height=([\\- 0-9]+)\\]");
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches() || matcher.groupCount() != 4) {
                throw new IllegalArgumentException("The given input '" + value + "' does not denote a valid rectangle.");
            }
            int x = Integer.parseInt(matcher.group(1));
            int y = Integer.parseInt(matcher.group(2));
            int width = Integer.parseInt(matcher.group(3));
            int height = Integer.parseInt(matcher.group(4));
            return new Rectangle(x, y, width, height);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing '" + value + "' to a valid rectangle.", e);
        }
    }

    @Override
    public Attribute applyChanges(Serializable actual) {
        return new OutlineAttribute(this.getKey(), (Rectangle)actual);
    }
}

