/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.ui.descriptors.DefaultAttribute;
import de.retest.ui.descriptors.ParameterParseException;
import de.retest.ui.descriptors.PathAttribute;
import de.retest.ui.descriptors.StringAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class ParameterType {
    private final String toString;
    private static final Map<String, ParameterType> registeredParameterTypes = new HashMap<String, ParameterType>();

    public ParameterType(String toString) {
        this.toString = toString;
    }

    public abstract Object parse(String var1) throws ParameterParseException;

    public boolean canParse(String value) {
        try {
            this.parse(value);
            return true;
        }
        catch (ParameterParseException e) {
            return false;
        }
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return this.toString.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ParameterType)) {
            return false;
        }
        return Objects.equals(this.toString, other.toString());
    }

    public static void registerParameterType(ParameterType type) {
        registeredParameterTypes.put(type.toString, type);
    }

    public static ParameterType getType(String type) {
        ParameterType parameterType = registeredParameterTypes.get(type);
        if (parameterType != null) {
            return parameterType;
        }
        throw new IllegalStateException("No ParameterType registered for parameters of type " + type);
    }

    public static void registerStdParameterTypes() {
        ParameterType.registerParameterType(PathAttribute.parameterTypePath);
        ParameterType.registerParameterType(DefaultAttribute.parameterTypeAttribute);
        ParameterType.registerParameterType(StringAttribute.parameterTypeString);
        ParameterType.registerParameterType(StringAttribute.parameterTypeBoolean);
        ParameterType.registerParameterType(StringAttribute.parameterTypeInteger);
        ParameterType.registerParameterType(StringAttribute.parameterTypeClass);
    }
}

