/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.ui.Path;
import de.retest.ui.descriptors.Attribute;
import de.retest.ui.descriptors.ParameterParseException;
import de.retest.ui.descriptors.ParameterType;
import de.retest.ui.descriptors.ParameterizedAttribute;
import de.retest.util.ObjectUtil;
import de.retest.util.StringSimilarity;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement
public class PathAttribute
extends ParameterizedAttribute {
    public static final ParameterType parameterTypePath = new ParameterType("PATH"){

        @Override
        public Object parse(String value) throws ParameterParseException {
            try {
                return Path.fromString(value);
            }
            catch (Exception e) {
                throw new ParameterParseException("Value must be a valid and parsable path.", e);
            }
        }
    };
    private static final long serialVersionUID = 1L;
    public static final String PATH_KEY = "path";
    @XmlValue
    private final String path;
    private transient Path cachedPath;

    protected PathAttribute() {
        this.path = null;
    }

    public PathAttribute(Path path) {
        this(path, null);
    }

    public PathAttribute(Path path, String variableName) {
        super(PATH_KEY, variableName);
        ObjectUtil.checkNull(path, PATH_KEY);
        this.cachedPath = path;
        this.path = path.toString();
    }

    @Override
    public Path getValue() {
        if (this.cachedPath == null) {
            this.cachedPath = Path.fromString(this.path);
        }
        return this.cachedPath;
    }

    @Override
    public double match(Attribute other) {
        if (!(other instanceof PathAttribute)) {
            return 0.0;
        }
        if (!other.getKey().equals(PATH_KEY)) {
            return 0.0;
        }
        String parentPath = this.getValue().getParentPath() == null ? "" : this.getValue().getParentPath().toString();
        Path otherPath = ((PathAttribute)other).getValue();
        String otherParentPath = otherPath.getParentPath() == null ? "" : otherPath.getParentPath().toString();
        return StringSimilarity.pathSimilarity(parentPath, otherParentPath);
    }

    @Override
    public Attribute applyChanges(Serializable actual) {
        if (actual instanceof String) {
            return new PathAttribute(Path.fromString((String)((Object)actual)), this.getVariableName());
        }
        return new PathAttribute((Path)actual, this.getVariableName());
    }

    @Override
    public ParameterizedAttribute applyVariableChange(String variableName) {
        return new PathAttribute(this.getValue(), variableName);
    }

    @Override
    public ParameterType getType() {
        return parameterTypePath;
    }
}

