/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors.idproviders;

import de.retest.ui.descriptors.IdentifyingAttributes;
import de.retest.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.util.RetestIdUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class DefaultRetestIdProvider
implements RetestIdProvider {
    private static final String DELIMITER = "-";
    private final Set<String> knownRetestIds = new HashSet<String>();

    @Override
    public String getRetestId(IdentifyingAttributes identifyingAttributes) {
        if (identifyingAttributes == null) {
            throw new NullPointerException("Identifying attributes must not be null.");
        }
        String text = RetestIdUtil.normalizeAndCut((String)identifyingAttributes.get("text"));
        String type = RetestIdUtil.normalizeAndCut(RetestIdUtil.cutTypeQualifier((String)identifyingAttributes.get("type")));
        String rawId = StringUtils.isNotBlank((CharSequence)text) ? text : type;
        String id = StringUtils.isNotBlank((CharSequence)rawId) ? rawId : this.getUniqueSuffix();
        return this.makeUnique(id);
    }

    private String makeUnique(String id) {
        String uniqueId = id;
        while (this.knownRetestIds.contains(uniqueId)) {
            uniqueId = id + DELIMITER + this.getUniqueSuffix();
        }
        this.knownRetestIds.add(uniqueId);
        return uniqueId;
    }

    private String getUniqueSuffix() {
        return UUID.randomUUID().toString().substring(0, 5);
    }

    @Override
    public void reset() {
        this.knownRetestIds.clear();
    }
}

