/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.review;

import de.retest.ui.Path;
import de.retest.ui.descriptors.IdentifyingAttributes;
import de.retest.ui.diff.AttributeDifference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeChanges {
    private final Map<Path, Set<AttributeDifference>> changes = new HashMap<Path, Set<AttributeDifference>>();

    AttributeChanges() {
    }

    public boolean contains(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        Path path = identifyingAttributes.getPathTyped();
        return this.changes.containsKey(path) && this.changes.get(path).contains(attributeDifference);
    }

    public void add(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        Path path = identifyingAttributes.getPathTyped();
        if (this.changes.containsKey(path)) {
            this.changes.get(path).add(attributeDifference);
        } else {
            HashSet<AttributeDifference> differences = new HashSet<AttributeDifference>();
            differences.add(attributeDifference);
            this.changes.put(path, differences);
        }
    }

    public void remove(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        Set<AttributeDifference> attributeDifferences = this.changes.get(identifyingAttributes.getPathTyped());
        if (attributeDifferences != null) {
            attributeDifferences.remove(attributeDifference);
        }
    }

    public Set<AttributeDifference> getAll(IdentifyingAttributes identifyingAttributes) {
        Set<AttributeDifference> result = this.changes.get(identifyingAttributes.getPathTyped());
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public void addAll(IdentifyingAttributes identifyingAttributes, List<AttributeDifference> attributes) {
        for (AttributeDifference attributeDifference : attributes) {
            this.add(identifyingAttributes, attributeDifference);
        }
    }

    public String toString() {
        return "AttributeChanges [" + this.changes + "]";
    }

    public int size() {
        return this.changes.size();
    }
}

