/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.nustaq.net.TCPObjectSocket;
import org.nustaq.serialization.FSTConfiguration;

public class TCPObjectServer {
    ServerSocket welcomeSocket;
    FSTConfiguration conf;
    int port;
    volatile boolean terminated;

    public TCPObjectServer(FSTConfiguration conf, int port) {
        this.conf = conf;
        this.port = port;
    }

    public TCPObjectServer(int port) {
        this.conf = FSTConfiguration.createDefaultConfiguration();
        this.port = port;
    }

    public void start(final NewClientListener listener) throws IOException {
        new Thread("server " + this.port){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TCPObjectServer.this.welcomeSocket = new ServerSocket(TCPObjectServer.this.port);
                    int count = 0;
                    while (!TCPObjectServer.this.terminated) {
                        final Socket connectionSocket = TCPObjectServer.this.welcomeSocket.accept();
                        new Thread("tcp client " + count++){

                            @Override
                            public void run() {
                                try {
                                    listener.connectionAccepted(new TCPObjectSocket(connectionSocket, TCPObjectServer.this.conf));
                                }
                                catch (IOException e) {
                                    TCPObjectServer.this.dumpException(e);
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception e) {
                    TCPObjectServer.this.dumpException(e);
                }
                finally {
                    TCPObjectServer.this.setTerminated(true);
                }
            }
        }.start();
    }

    protected void dumpException(Throwable th) {
        th.printStackTrace();
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public static interface NewClientListener {
        public void connectionAccepted(TCPObjectSocket var1);
    }
}

