/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaParameter;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import de.rweisleder.archunit.spring.internal.InternalUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ReflectionUtils;

public final class SpringAnnotationPredicates {
    private static final MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();

    private SpringAnnotationPredicates() {
    }

    public static DescribedPredicate<CanBeAnnotated> springAnnotatedWith(Class<? extends Annotation> annotationType) {
        return SpringAnnotationPredicates.springAnnotatedWith((DescribedPredicate<MergedAnnotations>)DescribedPredicate.describe((String)("@" + annotationType.getSimpleName()), mergedAnnotations -> mergedAnnotations.isPresent(annotationType)));
    }

    public static DescribedPredicate<CanBeAnnotated> springAnnotatedWith(String annotationTypeName) {
        return SpringAnnotationPredicates.springAnnotatedWith((DescribedPredicate<MergedAnnotations>)DescribedPredicate.describe((String)("@" + Formatters.ensureSimpleName((String)annotationTypeName)), mergedAnnotations -> mergedAnnotations.isPresent(annotationTypeName)));
    }

    public static <T extends Annotation> DescribedPredicate<CanBeAnnotated> springAnnotatedWith(Class<T> annotationType, DescribedPredicate<T> predicate) {
        return SpringAnnotationPredicates.springAnnotatedWith((DescribedPredicate<MergedAnnotations>)DescribedPredicate.describe((String)predicate.getDescription(), mergedAnnotations -> {
            MergedAnnotation mergedAnnotation = mergedAnnotations.get(annotationType);
            if (!mergedAnnotation.isPresent()) {
                return false;
            }
            Annotation synthesizedAnnotation = mergedAnnotation.synthesize();
            return predicate.test((Object)synthesizedAnnotation);
        }));
    }

    public static DescribedPredicate<CanBeAnnotated> springAnnotatedWith(DescribedPredicate<MergedAnnotations> predicate) {
        return DescribedPredicate.describe((String)("annotated with " + predicate.getDescription()), annotated -> {
            MergedAnnotations mergedAnnotations = SpringAnnotationPredicates.mergedAnnotations(annotated);
            if (mergedAnnotations == null) {
                return false;
            }
            return predicate.test((Object)mergedAnnotations);
        });
    }

    private static MergedAnnotations mergedAnnotations(CanBeAnnotated annotated) {
        try {
            AnnotatedElement annotatedElement = SpringAnnotationPredicates.asAnnotatedElement(annotated);
            if (annotatedElement == null) {
                return null;
            }
            return MergedAnnotations.from((AnnotatedElement)annotatedElement);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return SpringAnnotationPredicates.mergedAnnotationsFromMetadata(annotated);
        }
    }

    private static AnnotatedElement asAnnotatedElement(CanBeAnnotated annotated) {
        if (annotated instanceof JavaClass) {
            return ((JavaClass)annotated).reflect();
        }
        if (annotated instanceof JavaStaticInitializer) {
            return null;
        }
        if (annotated instanceof JavaField) {
            return ((JavaField)annotated).reflect();
        }
        if (annotated instanceof JavaConstructor) {
            return ((JavaConstructor)annotated).reflect();
        }
        if (annotated instanceof JavaMethod) {
            return ((JavaMethod)annotated).reflect();
        }
        if (annotated instanceof JavaParameter) {
            JavaCodeUnit owner = ((JavaParameter)annotated).getOwner();
            int index = ((JavaParameter)annotated).getIndex();
            if (owner instanceof JavaConstructor) {
                Constructor constructor = ((JavaConstructor)owner).reflect();
                return constructor.getParameters()[index];
            }
            if (owner instanceof JavaMethod) {
                Method method = ((JavaMethod)owner).reflect();
                return method.getParameters()[index];
            }
        }
        if (annotated instanceof AccessTarget) {
            Optional accessedMember = ((AccessTarget)annotated).resolveMember();
            if (!accessedMember.isPresent()) {
                return null;
            }
            return SpringAnnotationPredicates.asAnnotatedElement((CanBeAnnotated)accessedMember.get());
        }
        throw new EvaluationException(annotated + " cannot be converted to " + AnnotatedElement.class);
    }

    private static MergedAnnotations mergedAnnotationsFromMetadata(CanBeAnnotated annotated) {
        if (annotated instanceof JavaClass) {
            AnnotationMetadata annotationMetadata = SpringAnnotationPredicates.readAnnotationMetadata((JavaClass)annotated);
            if (annotationMetadata == null) {
                return null;
            }
            return annotationMetadata.getAnnotations();
        }
        if (annotated instanceof JavaMethod) {
            AnnotationMetadata annotationMetadata = SpringAnnotationPredicates.readAnnotationMetadata(((JavaMethod)annotated).getOwner());
            if (annotationMetadata == null) {
                return null;
            }
            MethodMetadata methodMetadata = SpringAnnotationPredicates.findMethodMetadata(annotationMetadata, (JavaMethod)annotated);
            if (methodMetadata == null) {
                return null;
            }
            return methodMetadata.getAnnotations();
        }
        return null;
    }

    private static AnnotationMetadata readAnnotationMetadata(JavaClass javaClass) {
        try {
            MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(javaClass.getName());
            return metadataReader.getAnnotationMetadata();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private static MethodMetadata findMethodMetadata(AnnotationMetadata annotationMetadata, JavaMethod javaMethod) {
        Collection<Object> methodMetadataSet = Collections.emptyList();
        if (InternalUtils.isSpringFramework6()) {
            methodMetadataSet = annotationMetadata.getDeclaredMethods();
        } else {
            Field annotatedMethodsField = ReflectionUtils.findField(annotationMetadata.getClass(), (String)"annotatedMethods");
            if (annotatedMethodsField != null) {
                ReflectionUtils.makeAccessible((Field)annotatedMethodsField);
                MethodMetadata[] annotatedMethods = (MethodMetadata[])ReflectionUtils.getField((Field)annotatedMethodsField, (Object)annotationMetadata);
                if (annotatedMethods != null) {
                    methodMetadataSet = Arrays.asList(annotatedMethods);
                }
            }
        }
        MethodMetadata matchingMethodMetadata = null;
        for (MethodMetadata methodMetadata : methodMetadataSet) {
            if (!methodMetadata.getMethodName().equals(javaMethod.getName())) continue;
            if (matchingMethodMetadata == null) {
                matchingMethodMetadata = methodMetadata;
                continue;
            }
            return null;
        }
        return matchingMethodMetadata;
    }

    public static class EvaluationException
    extends RuntimeException {
        EvaluationException(String message) {
            super(message);
        }
    }
}

