/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.boot;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SpringBootRules {
    private static final DescribedPredicate<CanBeAnnotated> annotatedWithSpringBootApplication = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.boot.autoconfigure.SpringBootApplication");
    private static final DescribedPredicate<CanBeAnnotated> annotatedWithSpringBootConfiguration = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.boot.SpringBootConfiguration");
    public static final ArchRule AllTypesInApplicationPackage = ((ArchRule)ArchRuleDefinition.classes().should(SpringBootRules.beInApplicationPackage()).as("all types of a Spring Boot application should be located in the same package or a sub-package of the application class")).allowEmptyShould(true);
    public static final ArchRule ApplicationHasOnlyOneSpringBootConfiguration = ((ArchRule)ArchRuleDefinition.classes().should(SpringBootRules.haveOnlyOneSpringBootConfiguration()).as("application should have only one class annotated with @SpringBootApplication or @SpringBootConfiguration")).allowEmptyShould(true);

    private SpringBootRules() {
    }

    public static ArchCondition<JavaClass> beInApplicationPackage() {
        return new ArchCondition<JavaClass>("be located in the same package or a sub-package of the application class", new Object[0]){
            private ArchCondition<JavaClass> inApplicationPackageCondition;

            public void init(Collection<JavaClass> javaClasses) {
                List springBootApplicationClasses = javaClasses.stream().filter((Predicate<JavaClass>)annotatedWithSpringBootConfiguration).collect(Collectors.toList());
                if (springBootApplicationClasses.isEmpty()) {
                    throw new AssertionError((Object)"Could not locate a class annotated with @SpringBootApplication or @SpringBootConfiguration");
                }
                String[] applicationPackageIdentifiers = (String[])springBootApplicationClasses.stream().map(javaClass -> javaClass.getPackageName() + "..").distinct().toArray(String[]::new);
                this.inApplicationPackageCondition = ArchConditions.resideInAnyPackage((String[])applicationPackageIdentifiers);
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                this.inApplicationPackageCondition.check((Object)javaClass, events);
            }
        };
    }

    public static ArchCondition<JavaClass> haveOnlyOneSpringBootConfiguration() {
        return new ArchCondition<JavaClass>("have only one class annotated with @SpringBootApplication or @SpringBootConfiguration", new Object[0]){
            private List<JavaClass> springBootConfigurationClasses;

            public void init(Collection<JavaClass> javaClasses) {
                this.springBootConfigurationClasses = javaClasses.stream().filter((Predicate<JavaClass>)annotatedWithSpringBootConfiguration).collect(Collectors.toList());
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                String message = annotatedWithSpringBootApplication.test((Object)javaClass) ? ConditionEvent.createMessage((HasDescription)javaClass, (String)"is annotated with @SpringBootApplication") : (annotatedWithSpringBootConfiguration.test((Object)javaClass) ? ConditionEvent.createMessage((HasDescription)javaClass, (String)"is annotated with @SpringBootConfiguration") : ConditionEvent.createMessage((HasDescription)javaClass, (String)"is not annotated with @SpringBootApplication or @SpringBootConfiguration"));
                if (this.springBootConfigurationClasses.size() > 1 && this.springBootConfigurationClasses.contains(javaClass)) {
                    events.add(SimpleConditionEvent.violated((Object)javaClass, (String)message));
                } else {
                    events.add(SimpleConditionEvent.satisfied((Object)javaClass, (String)message));
                }
            }
        };
    }
}

