/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.framework;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;
import de.rweisleder.archunit.spring.framework.SpringProxyPredicates;
import de.rweisleder.archunit.spring.internal.InternalUtils;

public final class SpringAsyncPredicates {
    private SpringAsyncPredicates() {
    }

    public static DescribedPredicate<JavaMethod> consideredAsAsynchronous() {
        DescribedPredicate<CanBeAnnotated> annotatedWithAsync = SpringAsyncPredicates.annotatedWithAsyncOrAsynchronous();
        DescribedPredicate methodAnnotatedWithAsync = annotatedWithAsync.forSubtype();
        DescribedPredicate declaredInClassAnnotatedWithAsync = JavaMember.Predicates.declaredIn(annotatedWithAsync).forSubtype();
        DescribedPredicate<JavaMethod> methodIsProxyable = SpringProxyPredicates.proxyable();
        return methodAnnotatedWithAsync.or(declaredInClassAnnotatedWithAsync.and(methodIsProxyable)).as("annotated with @Async or @Asynchronous (directly or at class level)", new Object[0]);
    }

    private static DescribedPredicate<CanBeAnnotated> annotatedWithAsyncOrAsynchronous() {
        DescribedPredicate<CanBeAnnotated> async = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.scheduling.annotation.Async");
        DescribedPredicate asynchronous = InternalUtils.isSpringFramework6() ? SpringAnnotationPredicates.springAnnotatedWith("jakarta.ejb.Asynchronous").or(SpringAnnotationPredicates.springAnnotatedWith("jakarta.enterprise.concurrent.Asynchronous")) : SpringAnnotationPredicates.springAnnotatedWith("javax.ejb.Asynchronous");
        return async.or(asynchronous).as("annotated with @Async or @Asynchronous", new Object[0]);
    }
}

