/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.framework;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;
import de.rweisleder.archunit.spring.framework.SpringAsyncPredicates;
import de.rweisleder.archunit.spring.framework.SpringProxyRules;
import de.rweisleder.archunit.spring.internal.InternalUtils;
import java.util.Collection;
import java.util.concurrent.Future;

public final class SpringAsyncRules {
    public static final ArchRule AsyncMethodsAreProxyable = ArchRuleDefinition.all(InternalUtils.availableMethods()).that(ArchPredicates.are(SpringAsyncPredicates.consideredAsAsynchronous())).should(SpringProxyRules.beProxyable()).allowEmptyShould(true);
    public static final ArchRule AsyncMethodsHaveSuitableReturnType = ArchRuleDefinition.methods().that(ArchPredicates.are(SpringAsyncPredicates.consideredAsAsynchronous())).should(ArchConditions.haveRawReturnType((DescribedPredicate)JavaClass.Predicates.assignableTo(Void.TYPE).or(JavaClass.Predicates.assignableTo(Future.class))).as("have return type void or java.util.concurrent.Future", new Object[0])).allowEmptyShould(true);
    public static final ArchRule AsyncMethodsNotCalledFromSameClass = ArchRuleDefinition.all(InternalUtils.availableMethods()).that(ArchPredicates.are(SpringAsyncPredicates.consideredAsAsynchronous())).should(SpringProxyRules.notBeCalledFromWithinTheSameClass()).allowEmptyShould(true);
    public static final ArchRule EnableAsyncIsPresentIfAsyncMethodsExist = ((ArchRule)ArchRuleDefinition.classes().should(SpringAsyncRules.haveEnableAsyncPresentIfAsyncMethodsExist()).as("application should contain a class annotated with @EnableAsync if any method is annotated with @Async")).allowEmptyShould(true);

    private SpringAsyncRules() {
    }

    public static ArchCondition<JavaClass> haveEnableAsyncPresentIfAsyncMethodsExist() {
        return new ArchCondition<JavaClass>("have @EnableAsync present if methods annotated with @Async exist", new Object[0]){
            private final DescribedPredicate<JavaMethod> consideredAsAsynchronous = SpringAsyncPredicates.consideredAsAsynchronous();
            private final DescribedPredicate<JavaClass> annotatedWithEnableAsync = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.scheduling.annotation.EnableAsync").forSubtype();
            private boolean classesHaveMethodConsideredAsAsynchronous = false;
            private boolean hasClassAnnotatedWithEnableAsync = false;

            public void init(Collection<JavaClass> javaClasses) {
                this.classesHaveMethodConsideredAsAsynchronous = javaClasses.stream().flatMap(javaClass -> javaClass.getAllMethods().stream()).anyMatch(this.consideredAsAsynchronous);
                this.hasClassAnnotatedWithEnableAsync = false;
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (this.classesHaveMethodConsideredAsAsynchronous) {
                    boolean classAnnotatedWithEnableAsync = this.annotatedWithEnableAsync.test((Object)javaClass);
                    if (classAnnotatedWithEnableAsync) {
                        events.add(SimpleConditionEvent.satisfied((Object)javaClass, (String)ConditionEvent.createMessage((HasDescription)javaClass, (String)("is " + this.annotatedWithEnableAsync.getDescription()))));
                    }
                    this.hasClassAnnotatedWithEnableAsync |= classAnnotatedWithEnableAsync;
                }
            }

            public void finish(ConditionEvents events) {
                if (this.classesHaveMethodConsideredAsAsynchronous && !this.hasClassAnnotatedWithEnableAsync) {
                    events.add(SimpleConditionEvent.violated(null, (String)"application contains no class annotated with @EnableAsync"));
                }
            }
        };
    }
}

