/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.framework;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;
import de.rweisleder.archunit.spring.framework.SpringProxyRules;
import de.rweisleder.archunit.spring.internal.InternalUtils;
import java.util.Collection;

public final class SpringCacheRules {
    public static final ArchRule CacheableMethodsAreProxyable = ArchRuleDefinition.all(InternalUtils.availableMethods()).that(ArchPredicates.are(SpringAnnotationPredicates.springAnnotatedWith("org.springframework.cache.annotation.Cacheable"))).should(SpringProxyRules.beProxyable()).allowEmptyShould(true);
    public static final ArchRule CacheableMethodsNotCalledFromSameClass = ArchRuleDefinition.all(InternalUtils.availableMethods()).that(ArchPredicates.are(SpringAnnotationPredicates.springAnnotatedWith("org.springframework.cache.annotation.Cacheable"))).should(SpringProxyRules.notBeCalledFromWithinTheSameClass()).allowEmptyShould(true);
    public static final ArchRule EnableCachingIsPresentIfCacheableMethodsExist = ((ArchRule)ArchRuleDefinition.classes().should(SpringCacheRules.haveEnableCachingPresentIfCacheableMethodsExist()).as("application should contain a class annotated with @EnableCaching if any method is annotated with @Cacheable")).allowEmptyShould(true);

    private SpringCacheRules() {
    }

    public static ArchCondition<JavaClass> haveEnableCachingPresentIfCacheableMethodsExist() {
        return new ArchCondition<JavaClass>("have @EnableCaching present if methods annotated with @Cacheable exist", new Object[0]){
            private final DescribedPredicate<JavaMethod> annotatedWithCacheable = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.cache.annotation.Cacheable").forSubtype();
            private final DescribedPredicate<JavaClass> annotatedWithEnableCaching = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.cache.annotation.EnableCaching").forSubtype();
            private boolean classesHaveMethodAnnotatedWithCacheable = false;
            private boolean hasClassAnnotatedWithEnableCaching = false;

            public void init(Collection<JavaClass> javaClasses) {
                this.classesHaveMethodAnnotatedWithCacheable = javaClasses.stream().flatMap(javaClass -> javaClass.getAllMethods().stream()).anyMatch(this.annotatedWithCacheable);
                this.hasClassAnnotatedWithEnableCaching = false;
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (this.classesHaveMethodAnnotatedWithCacheable) {
                    boolean classAnnotatedWithEnableCaching = this.annotatedWithEnableCaching.test((Object)javaClass);
                    if (classAnnotatedWithEnableCaching) {
                        events.add(SimpleConditionEvent.satisfied((Object)javaClass, (String)ConditionEvent.createMessage((HasDescription)javaClass, (String)("is " + this.annotatedWithEnableCaching.getDescription()))));
                    }
                    this.hasClassAnnotatedWithEnableCaching |= classAnnotatedWithEnableCaching;
                }
            }

            public void finish(ConditionEvents events) {
                if (this.classesHaveMethodAnnotatedWithCacheable && !this.hasClassAnnotatedWithEnableCaching) {
                    events.add(SimpleConditionEvent.violated(null, (String)"application contains no class annotated with @EnableCaching"));
                }
            }
        };
    }
}

