/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.framework;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;

public final class SpringComponentPredicates {
    private SpringComponentPredicates() {
    }

    public static DescribedPredicate<JavaClass> springComponent() {
        DescribedPredicate hasComponentAnnotation = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.stereotype.Component").forSubtype();
        DescribedPredicate<JavaClass> isSpringDataRepository = SpringComponentPredicates.springDataRepository();
        return hasComponentAnnotation.or(isSpringDataRepository).as("Spring component", new Object[0]);
    }

    public static DescribedPredicate<JavaClass> springController() {
        return SpringAnnotationPredicates.springAnnotatedWith("org.springframework.stereotype.Controller").as("Spring controller", new Object[0]).forSubtype();
    }

    public static DescribedPredicate<JavaClass> springService() {
        return SpringAnnotationPredicates.springAnnotatedWith("org.springframework.stereotype.Service").as("Spring service", new Object[0]).forSubtype();
    }

    public static DescribedPredicate<JavaClass> springRepository() {
        DescribedPredicate hasRepositoryAnnotation = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.stereotype.Repository").forSubtype();
        DescribedPredicate<JavaClass> isSpringDataRepository = SpringComponentPredicates.springDataRepository();
        return hasRepositoryAnnotation.or(isSpringDataRepository).as("Spring repository", new Object[0]);
    }

    private static DescribedPredicate<JavaClass> springDataRepository() {
        return JavaClass.Predicates.assignableTo((String)"org.springframework.data.repository.Repository").and(DescribedPredicate.not((DescribedPredicate)SpringAnnotationPredicates.springAnnotatedWith("org.springframework.data.repository.NoRepositoryBean").forSubtype()));
    }

    public static DescribedPredicate<JavaClass> springConfiguration() {
        return SpringAnnotationPredicates.springAnnotatedWith("org.springframework.context.annotation.Configuration").as("Spring configuration", new Object[0]).forSubtype();
    }
}

