/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.framework;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import de.rweisleder.archunit.spring.internal.InternalUtils;

public final class SpringProxyRules {
    private SpringProxyRules() {
    }

    public static ArchCondition<JavaMethod> beProxyable() {
        return new ArchCondition<JavaMethod>("be proxyable", new Object[0]){
            private final boolean isSpringFramework6 = InternalUtils.isSpringFramework6();
            private final ArchCondition<JavaMethod> notDeclaredInInterface = ArchConditions.not((ArchCondition)new ArchCondition<JavaMethod>("declared in class that is an interface", new Object[0]){

                public void check(JavaMethod javaMethod, ConditionEvents events) {
                    if (javaMethod.getOwner().isInterface()) {
                        events.add(SimpleConditionEvent.satisfied((Object)javaMethod, (String)ConditionEvent.createMessage((HasDescription)javaMethod, (String)"is declared in class that is an interface")));
                    } else {
                        events.add(SimpleConditionEvent.violated((Object)javaMethod, (String)ConditionEvent.createMessage((HasDescription)javaMethod, (String)"is not declared in class that is an interface")));
                    }
                }
            });
            private final ArchCondition<JavaClass> nonFinalClass = ArchConditions.notBeFinal();
            private final ArchCondition<JavaMethod> nonFinalMethod = ArchConditions.notBeFinal();
            private final ArchCondition<JavaMethod> nonStaticMethod = ArchConditions.notBeStatic();
            private final ArchCondition<JavaMethod> publicMethod = ArchConditions.bePublic();
            private final ArchCondition<JavaMethod> publicOrProtectedMethod = ArchConditions.bePublic().or(ArchConditions.beProtected()).forSubtype();
            private final ArchCondition<JavaMethod> nonPrivateMethod = ArchConditions.notBePrivate();

            public void check(JavaMethod method, ConditionEvents events) {
                JavaClass owner = method.getOwner();
                this.nonFinalClass.check((Object)owner, events);
                for (JavaClass subclass : owner.getAllSubclasses()) {
                    this.nonFinalClass.check((Object)subclass, events);
                }
                this.notDeclaredInInterface.check((Object)method, events);
                this.nonFinalMethod.check((Object)method, events);
                this.nonStaticMethod.check((Object)method, events);
                if (this.isSpringFramework6) {
                    if (this.hasSubclassInDifferentPackage(owner)) {
                        this.publicOrProtectedMethod.check((Object)method, events);
                    } else {
                        this.nonPrivateMethod.check((Object)method, events);
                    }
                } else {
                    this.publicMethod.check((Object)method, events);
                }
            }

            private boolean hasSubclassInDifferentPackage(JavaClass javaClass) {
                for (JavaClass subclass : javaClass.getAllSubclasses()) {
                    if (subclass.getPackage().equals(javaClass.getPackage())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ArchCondition<JavaMethod> notBeCalledFromWithinTheSameClass() {
        return new ArchCondition<JavaMethod>("not be called from within the same class", new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                for (JavaMethodCall methodCall : method.getCallsOfSelf()) {
                    boolean calledFromWithinSameClass = methodCall.getOriginOwner().equals(methodCall.getTargetOwner());
                    if (!calledFromWithinSameClass) continue;
                    events.add(SimpleConditionEvent.violated((Object)method, (String)methodCall.getDescription()));
                }
            }
        };
    }
}

