/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.framework;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;
import java.util.Collection;

public final class SpringScheduledRules {
    public static final ArchRule EnableSchedulingIsPresentIfScheduledMethodsExist = ((ArchRule)ArchRuleDefinition.classes().should(SpringScheduledRules.haveEnableSchedulingPresentIfScheduledMethodsExist()).as("application should contain a class annotated with @EnableScheduling if any method is annotated with @Scheduled")).allowEmptyShould(true);

    private SpringScheduledRules() {
    }

    public static ArchCondition<JavaClass> haveEnableSchedulingPresentIfScheduledMethodsExist() {
        return new ArchCondition<JavaClass>("have @EnableScheduling present if methods annotated with @Scheduled exist", new Object[0]){
            private final DescribedPredicate<JavaMethod> annotatedWithScheduled = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.scheduling.annotation.Scheduled").forSubtype();
            private final DescribedPredicate<JavaClass> annotatedWithEnableScheduling = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.scheduling.annotation.EnableScheduling").forSubtype();
            private boolean classesHaveMethodAnnotatedWithScheduled = false;
            private boolean hasClassAnnotatedWithEnableScheduling = false;

            public void init(Collection<JavaClass> javaClasses) {
                this.classesHaveMethodAnnotatedWithScheduled = javaClasses.stream().flatMap(javaClass -> javaClass.getAllMethods().stream()).anyMatch(this.annotatedWithScheduled);
                this.hasClassAnnotatedWithEnableScheduling = false;
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (this.classesHaveMethodAnnotatedWithScheduled) {
                    boolean classAnnotatedWithEnableScheduling = this.annotatedWithEnableScheduling.test((Object)javaClass);
                    if (classAnnotatedWithEnableScheduling) {
                        events.add(SimpleConditionEvent.satisfied((Object)javaClass, (String)ConditionEvent.createMessage((HasDescription)javaClass, (String)("is " + this.annotatedWithEnableScheduling.getDescription()))));
                    }
                    this.hasClassAnnotatedWithEnableScheduling |= classAnnotatedWithEnableScheduling;
                }
            }

            public void finish(ConditionEvents events) {
                if (this.classesHaveMethodAnnotatedWithScheduled && !this.hasClassAnnotatedWithEnableScheduling) {
                    events.add(SimpleConditionEvent.violated(null, (String)"application contains no class annotated with @EnableScheduling"));
                }
            }
        };
    }
}

