/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.internal;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.AbstractClassesTransformer;
import com.tngtech.archunit.lang.ClassesTransformer;
import java.util.HashSet;
import org.springframework.util.ClassUtils;

public final class InternalUtils {
    private static Boolean isSpringFramework6;

    private InternalUtils() {
    }

    public static ClassesTransformer<JavaMethod> availableMethods() {
        return new AbstractClassesTransformer<JavaMethod>("methods"){

            public Iterable<JavaMethod> doTransform(JavaClasses javaClasses) {
                HashSet<JavaMethod> availableMethods = new HashSet<JavaMethod>();
                for (JavaClass javaClass : javaClasses) {
                    availableMethods.addAll(javaClass.getAllMethods());
                }
                return availableMethods;
            }
        };
    }

    public static boolean isSpringFramework6() {
        if (isSpringFramework6 == null) {
            isSpringFramework6 = ClassUtils.isPresent((String)"org.springframework.aot.AotDetector", null);
        }
        return isSpringFramework6;
    }
}

