/*
 * Decompiled with CFR 0.152.
 */
package de.rweisleder.archunit.spring.retry;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import de.rweisleder.archunit.spring.SpringAnnotationPredicates;
import de.rweisleder.archunit.spring.framework.SpringProxyRules;
import de.rweisleder.archunit.spring.internal.InternalUtils;
import java.util.Collection;

public final class SpringRetryRules {
    public static final ArchRule RetryableMethodsAreProxyable = ArchRuleDefinition.all(InternalUtils.availableMethods()).that(ArchPredicates.are(SpringAnnotationPredicates.springAnnotatedWith("org.springframework.retry.annotation.Retryable"))).should(SpringProxyRules.beProxyable()).allowEmptyShould(true);
    public static final ArchRule RetryableMethodsNotCalledFromSameClass = ArchRuleDefinition.all(InternalUtils.availableMethods()).that(ArchPredicates.are(SpringAnnotationPredicates.springAnnotatedWith("org.springframework.retry.annotation.Retryable"))).should(SpringProxyRules.notBeCalledFromWithinTheSameClass()).allowEmptyShould(true);
    public static final ArchRule EnableRetryIsPresentIfRetryableMethodsExist = ((ArchRule)ArchRuleDefinition.classes().should(SpringRetryRules.haveEnableRetryPresentIfRetryableMethodsExist()).as("application should contain a class annotated with @EnableRetry if any method is annotated with @Retryable")).allowEmptyShould(true);

    private SpringRetryRules() {
    }

    public static ArchCondition<JavaClass> haveEnableRetryPresentIfRetryableMethodsExist() {
        return new ArchCondition<JavaClass>("have @EnableRetry present if methods annotated with @Retryable exist", new Object[0]){
            private final DescribedPredicate<JavaMethod> annotatedWithRetryable = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.retry.annotation.Retryable").forSubtype();
            private final DescribedPredicate<JavaClass> annotatedWithEnableRetry = SpringAnnotationPredicates.springAnnotatedWith("org.springframework.retry.annotation.EnableRetry").forSubtype();
            private boolean classesHaveMethodAnnotatedWithRetryable = false;
            private boolean hasClassAnnotatedWithEnableRetry = false;

            public void init(Collection<JavaClass> javaClasses) {
                this.classesHaveMethodAnnotatedWithRetryable = javaClasses.stream().flatMap(javaClass -> javaClass.getAllMethods().stream()).anyMatch(this.annotatedWithRetryable);
                this.hasClassAnnotatedWithEnableRetry = false;
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (this.classesHaveMethodAnnotatedWithRetryable) {
                    boolean classAnnotatedWithEnableRetry = this.annotatedWithEnableRetry.test((Object)javaClass);
                    if (classAnnotatedWithEnableRetry) {
                        events.add(SimpleConditionEvent.satisfied((Object)javaClass, (String)ConditionEvent.createMessage((HasDescription)javaClass, (String)("is " + this.annotatedWithEnableRetry.getDescription()))));
                    }
                    this.hasClassAnnotatedWithEnableRetry |= classAnnotatedWithEnableRetry;
                }
            }

            public void finish(ConditionEvents events) {
                if (this.classesHaveMethodAnnotatedWithRetryable && !this.hasClassAnnotatedWithEnableRetry) {
                    events.add(SimpleConditionEvent.violated(null, (String)"application contains no class annotated with @EnableRetry"));
                }
            }
        };
    }
}

