/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.classification;

import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IsolatingClassificationStrategy
implements ClassificationStrategy {
    private static final long MAXIMUM_NUMBER_OF_ITERATIONS = 100000L;
    private final ConstraintChecker checker;
    private final CompleteTestModel testModel;
    private final IntList parameters;
    private long numberOfPossibleTestInputs = 1L;
    private Set<IntList> involvedFailureInducingCombinations;
    private IntList currentlyProcessedCombination;
    private List<IntList> exceptionInducingCombinationsToClassify;
    final Map<IntList, Class<? extends Throwable>> classifiedExceptionInducingCombinations = new HashMap<IntList, Class<? extends Throwable>>();
    private Set<IntList> forbiddenTuples;

    public IsolatingClassificationStrategy(ClassificationConfiguration configuration) {
        this.checker = configuration.getConstraintChecker();
        this.testModel = configuration.getTestModel();
        int numberOfParameters = this.testModel.getNumberOfParameters();
        IntArrayList parameterSizes = new IntArrayList(this.testModel.getParameterSizes());
        parameterSizes.forEach(values -> this.numberOfPossibleTestInputs *= (long)values);
        this.numberOfPossibleTestInputs = Long.min(this.numberOfPossibleTestInputs, 100000L);
        if (this.numberOfPossibleTestInputs < 0L) {
            this.numberOfPossibleTestInputs = 100000L;
        }
        this.parameters = new IntArrayList(numberOfParameters);
        IntStream.range(0, numberOfParameters).forEach(arg_0 -> ((IntList)this.parameters).add(arg_0));
    }

    public static ClassificationStrategyFactory isolatingClassificationStrategy() {
        return IsolatingClassificationStrategy::new;
    }

    @Override
    public Optional<int[]> startClassification(Map<int[], Throwable> errorConstraintExceptionCausingTestInputs, List<int[]> exceptionInducingCombinationsToClassify, Set<int[]> possiblyFailureInducingCombinations) {
        this.exceptionInducingCombinationsToClassify = exceptionInducingCombinationsToClassify.stream().map(IntArrayList::new).collect(Collectors.toList());
        this.involvedFailureInducingCombinations = possiblyFailureInducingCombinations.stream().map(IntArrayList::new).collect(Collectors.toSet());
        IntArrayList emptyCombination = new IntArrayList(CombinationUtil.emptyCombination(this.testModel.getNumberOfParameters()));
        this.exceptionInducingCombinationsToClassify.remove(emptyCombination);
        this.involvedFailureInducingCombinations.remove(emptyCombination);
        this.forbiddenTuples = new HashSet<IntList>(this.exceptionInducingCombinationsToClassify);
        this.forbiddenTuples.addAll(this.involvedFailureInducingCombinations);
        Optional<int[]> nextTestInput = Optional.empty();
        if (!this.exceptionInducingCombinationsToClassify.isEmpty()) {
            while (!nextTestInput.isPresent() && !this.exceptionInducingCombinationsToClassify.isEmpty()) {
                this.currentlyProcessedCombination = this.exceptionInducingCombinationsToClassify.remove(0);
                nextTestInput = this.generateIsolatingTestInput(this.currentlyProcessedCombination);
            }
        }
        return nextTestInput;
    }

    @Override
    public Optional<int[]> generateNextTestInputForClassification(int[] testInput, TestResult result) {
        Optional<Throwable> optCause;
        if (result.isExceptionalSuccessful() && (optCause = result.getResultValue()).isPresent()) {
            if (optCause.get().getCause() == null) {
                this.classifiedExceptionInducingCombinations.put(this.currentlyProcessedCombination, ErrorConstraintException.class);
            } else {
                this.classifiedExceptionInducingCombinations.put(this.currentlyProcessedCombination, optCause.get().getCause().getClass());
            }
        }
        Optional<int[]> nextTestInput = Optional.empty();
        if (!this.exceptionInducingCombinationsToClassify.isEmpty()) {
            while (!nextTestInput.isPresent() && !this.exceptionInducingCombinationsToClassify.isEmpty()) {
                this.currentlyProcessedCombination = this.exceptionInducingCombinationsToClassify.remove(0);
                nextTestInput = this.generateIsolatingTestInput(this.currentlyProcessedCombination);
            }
        }
        return nextTestInput;
    }

    @Override
    public Map<int[], Class<? extends Throwable>> getClassifiedExceptionInducingCombinations() {
        return this.classifiedExceptionInducingCombinations.entrySet().stream().collect(Collectors.toMap(entry -> ((IntList)entry.getKey()).toIntArray(), Map.Entry::getValue));
    }

    private Optional<int[]> generateIsolatingTestInput(IntList exceptionInducingCombination) {
        Optional<int[]> optNextTestInput;
        int[] nextTestInput = null;
        this.forbiddenTuples = new HashSet<IntList>(this.exceptionInducingCombinationsToClassify);
        this.forbiddenTuples.addAll(this.classifiedExceptionInducingCombinations.keySet());
        this.forbiddenTuples.addAll(this.involvedFailureInducingCombinations);
        this.forbiddenTuples.remove(exceptionInducingCombination);
        long iteration = 1L;
        block0: while (nextTestInput == null && iteration < this.numberOfPossibleTestInputs) {
            nextTestInput = Arrays.copyOf(exceptionInducingCombination.toIntArray(), exceptionInducingCombination.size());
            ++iteration;
            Collections.shuffle(this.parameters);
            IntListIterator intListIterator = this.parameters.iterator();
            while (intListIterator.hasNext()) {
                int parameter = (Integer)intListIterator.next();
                if (nextTestInput[parameter] != -1) continue;
                Optional<ParameterValuePair> optimalValue = this.calculateOptimalValue(parameter, this.testModel.getParameterSize(parameter), nextTestInput, this.forbiddenTuples, this.checker);
                if (optimalValue.isPresent()) {
                    nextTestInput[parameter] = optimalValue.get().getValue();
                    continue;
                }
                this.forbiddenTuples.add((IntList)new IntArrayList(nextTestInput));
                nextTestInput = null;
                continue block0;
            }
        }
        if (nextTestInput != null) {
            optNextTestInput = Optional.of(nextTestInput);
            this.forbiddenTuples.add(exceptionInducingCombination);
        } else {
            optNextTestInput = Optional.empty();
        }
        return optNextTestInput;
    }

    private Optional<ParameterValuePair> calculateOptimalValue(int parameter, int sizeOfParameter, int[] nextTestInput, Set<IntList> forbiddenTuples, ConstraintChecker checker) {
        int[] candidateTestInput = Arrays.copyOf(nextTestInput, nextTestInput.length);
        IntArrayList values = new IntArrayList();
        IntStream.range(0, sizeOfParameter).forEach(arg_0 -> ((IntArrayList)values).add(arg_0));
        Collections.shuffle(values);
        IntListIterator intListIterator = values.iterator();
        while (intListIterator.hasNext()) {
            int value = (Integer)intListIterator.next();
            if (!checker.isExtensionValid(candidateTestInput, parameter, value)) continue;
            candidateTestInput[parameter] = value;
            boolean invalid = false;
            for (IntList forbiddenTuple : forbiddenTuples) {
                if (!CombinationUtil.contains(candidateTestInput, forbiddenTuple.toIntArray())) continue;
                invalid = true;
                break;
            }
            if (invalid) continue;
            return Optional.of(new ParameterValuePair(parameter, value));
        }
        return Optional.empty();
    }
}

