/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.classification;

import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MaxCountClassificationStrategy
implements ClassificationStrategy {
    private final Map<int[], Class<? extends Throwable>> classifiedExceptionInducingCombinations = new HashMap<int[], Class<? extends Throwable>>();
    private Map<int[], Throwable> errorConstraintExceptionCausingTestInputs;

    public MaxCountClassificationStrategy(ClassificationConfiguration configuration) {
    }

    public static ClassificationStrategyFactory maxCountClassificationStrategy() {
        return MaxCountClassificationStrategy::new;
    }

    @Override
    public Optional<int[]> startClassification(Map<int[], Throwable> errorConstraintExceptionCausingTestInputs, List<int[]> exceptionInducingCombinationsToClassify, Set<int[]> possiblyFailureInducingCombinations) {
        this.errorConstraintExceptionCausingTestInputs = errorConstraintExceptionCausingTestInputs;
        exceptionInducingCombinationsToClassify.forEach(this::classifyCombination);
        return Optional.empty();
    }

    private void classifyCombination(int[] combination) {
        List exceptionsRaisedByCombination = this.errorConstraintExceptionCausingTestInputs.entrySet().stream().filter(testInput -> CombinationUtil.contains((int[])testInput.getKey(), combination)).map(Map.Entry::getValue).collect(Collectors.toList());
        Class<?> type = exceptionsRaisedByCombination.stream().collect(Collectors.groupingBy(Object::getClass)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        if (type == null) {
            type = ((Throwable)exceptionsRaisedByCombination.get(0)).getClass();
        }
        this.classifiedExceptionInducingCombinations.put(combination, (Class<? extends Throwable>)type);
    }

    @Override
    public Optional<int[]> generateNextTestInputForClassification(int[] testInput, TestResult result) {
        return Optional.empty();
    }

    @Override
    public Map<int[], Class<? extends Throwable>> getClassifiedExceptionInducingCombinations() {
        return this.classifiedExceptionInducingCombinations;
    }
}

