/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.conflict.TestModelExpander;
import de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis.ConflictDiagnostician;
import de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis.NoConflictDiagnostician;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.ConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.NoConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;

public class ConflictDetectionConfiguration {
    private final boolean conflictDetectionEnabled;
    private final boolean shouldAbort;
    private final boolean conflictExplanationEnabled;
    private final Supplier<? extends ConflictExplainer> conflictExplainerSupplier;
    private final boolean conflictDiagnosisEnabled;
    private final Supplier<? extends ConflictDiagnostician> conflictDiagnosticianSupplier;

    public static ConflictDetectionConfiguration disable() {
        return new ConflictDetectionConfiguration(false, false, false, () -> null, false, () -> null);
    }

    private boolean implies(boolean a, boolean b) {
        return !a || b;
    }

    public ConflictDetectionConfiguration(boolean conflictDetectionEnabled, boolean shouldAbort, boolean conflictExplanationEnabled, Supplier<? extends ConflictExplainer> conflictExplainerSupplier, boolean conflictDiagnosisEnabled, Supplier<? extends ConflictDiagnostician> conflictDiagnosticianSupplier) {
        Preconditions.check(this.implies(conflictExplanationEnabled, conflictDetectionEnabled));
        Preconditions.check(this.implies(conflictExplanationEnabled, conflictExplainerSupplier != null));
        Preconditions.check(this.implies(conflictDiagnosisEnabled, conflictExplanationEnabled));
        Preconditions.check(this.implies(conflictDiagnosisEnabled, conflictDiagnosticianSupplier != null));
        this.conflictDetectionEnabled = conflictDetectionEnabled;
        this.shouldAbort = shouldAbort;
        this.conflictExplanationEnabled = conflictExplanationEnabled;
        this.conflictExplainerSupplier = !conflictExplanationEnabled ? NoConflictExplainer::new : conflictExplainerSupplier;
        this.conflictDiagnosisEnabled = conflictDiagnosisEnabled;
        this.conflictDiagnosticianSupplier = !conflictDiagnosisEnabled ? NoConflictDiagnostician::new : conflictDiagnosticianSupplier;
    }

    public boolean isConflictDetectionEnabled() {
        return this.conflictDetectionEnabled;
    }

    public boolean shouldAbort() {
        return this.shouldAbort;
    }

    public boolean isConflictExplanationEnabled() {
        return this.conflictExplanationEnabled;
    }

    public boolean isConflictDiagnosisEnabled() {
        return this.conflictDiagnosisEnabled;
    }

    public ConflictExplainer createConflictExplainer() {
        return this.conflictExplainerSupplier.get();
    }

    public ConflictDiagnostician createConflictDiagnostician() {
        return this.conflictDiagnosticianSupplier.get();
    }

    public TestModelExpander createTestModelExpander(CompleteTestModel testModel) {
        return new TestModelExpander(testModel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConflictDetectionConfiguration that = (ConflictDetectionConfiguration)o;
        return this.conflictDetectionEnabled == that.conflictDetectionEnabled && this.shouldAbort == that.shouldAbort && this.conflictExplanationEnabled == that.conflictExplanationEnabled && this.conflictDiagnosisEnabled == that.conflictDiagnosisEnabled && Objects.equals(this.conflictExplainerSupplier, that.conflictExplainerSupplier) && Objects.equals(this.conflictDiagnosticianSupplier, that.conflictDiagnosticianSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.conflictDetectionEnabled, this.shouldAbort, this.conflictExplanationEnabled, this.conflictExplainerSupplier, this.conflictDiagnosisEnabled, this.conflictDiagnosticianSupplier);
    }

    public String toString() {
        return "ConflictDetectionConfiguration{conflictDetectionEnabled=" + this.conflictDetectionEnabled + ", shouldAbort=" + this.shouldAbort + ", conflictExplanationEnabled=" + this.conflictExplanationEnabled + ", conflictExplainerSupplier=" + this.conflictExplainerSupplier + ", conflictDiagnosisEnabled=" + this.conflictDiagnosisEnabled + ", conflictDiagnosticianSupplier=" + this.conflictDiagnosticianSupplier + "}";
    }
}

