/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictDetectionConfiguration;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictDetectionResultConverter;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalDiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalInconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalUnknownExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.MissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.TestModelExpander;
import de.rwth.swc.coffee4j.algorithmic.conflict.choco.ChocoModel;
import de.rwth.swc.coffee4j.algorithmic.conflict.diagnosis.ConflictDiagnostician;
import de.rwth.swc.coffee4j.algorithmic.conflict.explanation.ConflictExplainer;
import de.rwth.swc.coffee4j.algorithmic.constraint.Constraint;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ConflictDetectionManager {
    private final ConflictDetectionConfiguration configuration;
    private final ConflictExplainer explainer;
    private final ConflictDiagnostician diagnostician;
    private final TestModelExpander expander;
    private final CompleteTestModel testModel;
    private final Map<Boolean, List<Constraint>> partitionedConstraints;
    private final ChocoModel chocoModel;

    public ConflictDetectionManager(ConflictDetectionConfiguration configuration, CompleteTestModel originalTestModel) {
        Preconditions.notNull(configuration);
        Preconditions.notNull(originalTestModel);
        this.configuration = configuration;
        this.explainer = configuration.createConflictExplainer();
        this.diagnostician = configuration.createConflictDiagnostician();
        this.expander = configuration.createTestModelExpander(originalTestModel);
        this.testModel = this.expander.createExpandedTestModel();
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.addAll(this.testModel.getExclusionConstraints());
        constraints.addAll(this.testModel.getErrorConstraints());
        this.partitionedConstraints = constraints.stream().collect(Collectors.groupingBy(constraint -> constraint.getTupleList().isMarkedAsCorrect()));
        if (!this.partitionedConstraints.containsKey(true)) {
            this.partitionedConstraints.put(true, Collections.emptyList());
        }
        this.chocoModel = new ChocoModel(this.testModel.getParameterSizes(), constraints);
    }

    public List<MissingInvalidTuple> detectMissingInvalidTuples() {
        if (!this.configuration.isConflictDetectionEnabled()) {
            return Collections.emptyList();
        }
        ConflictDetectionResultConverter converter = new ConflictDetectionResultConverter(this.testModel, this.expander);
        return this.testModel.getErrorTupleLists().stream().map(this::checkForNegatedErrorConstraint).flatMap(Collection::stream).map(converter::convertMissingInvalidTuple).collect(Collectors.toList());
    }

    private List<InternalMissingInvalidTuple> checkForNegatedErrorConstraint(TupleList toBeNegated) {
        ArrayList<InternalMissingInvalidTuple> missingInvalidTuples = new ArrayList<InternalMissingInvalidTuple>();
        this.chocoModel.reset();
        this.chocoModel.setNegationOfConstraint(toBeNegated.getId());
        for (int[] tuple : toBeNegated.getTuples()) {
            IntArraySet background = new IntArraySet();
            background.add(toBeNegated.getId());
            background.addAll((Collection)this.partitionedConstraints.get(true).stream().map(constraint -> constraint.getTupleList().getId()).collect(Collectors.toList()));
            IntArraySet relaxable = new IntArraySet();
            relaxable.addAll((Collection)this.partitionedConstraints.get(false).stream().filter(constraint -> constraint.getTupleList().getId() != toBeNegated.getId()).map(constraint -> constraint.getTupleList().getId()).collect(Collectors.toList()));
            Optional<InternalExplanation> optional = this.checkForInvalidTuple(toBeNegated, tuple, (IntSet)background, (IntSet)relaxable);
            optional.ifPresent(explanation -> missingInvalidTuples.add(new InternalMissingInvalidTuple(toBeNegated.getId(), toBeNegated.getInvolvedParameters(), tuple, (InternalExplanation)explanation)));
        }
        this.chocoModel.resetNegationOfConstraint();
        return missingInvalidTuples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<InternalExplanation> checkForInvalidTuple(TupleList tupleList, int[] tuple, IntSet background, IntSet relaxable) {
        this.chocoModel.reset();
        int assignmentId = this.chocoModel.setAssignmentConstraint(tupleList.getInvolvedParameters(), tuple);
        background.add(assignmentId);
        try {
            Optional<InternalExplanation> optional = this.createExplanation(background.toIntArray(), relaxable.toIntArray());
            Optional<InternalExplanation> optional2 = optional.map(explanation -> {
                if (this.configuration.isConflictDiagnosisEnabled() && explanation instanceof InternalConflictSet) {
                    return new InternalDiagnosisSets((InternalConflictSet)explanation, this.diagnostician.getMinimalDiagnoses((InternalConflictSet)explanation));
                }
                if (explanation instanceof InternalInconsistentBackground) {
                    return this.removeAssignmentConstraintFromBackground(assignmentId, (InternalInconsistentBackground)explanation);
                }
                return explanation;
            });
            return optional2;
        }
        finally {
            this.chocoModel.clearAssignmentConstraint();
            background.remove(assignmentId);
        }
    }

    private InternalExplanation removeAssignmentConstraintFromBackground(int assignmentId, InternalInconsistentBackground explanation) {
        int[] cleanedBackground = Arrays.stream(explanation.getBackground()).filter(c -> c != assignmentId).toArray();
        return new InternalInconsistentBackground(cleanedBackground, explanation.getRelaxable());
    }

    private Optional<InternalExplanation> createExplanation(int[] background, int[] relaxable) {
        if (!this.configuration.isConflictExplanationEnabled()) {
            this.chocoModel.reset();
            if (this.chocoModel.isSatisfiable()) {
                return Optional.empty();
            }
            return Optional.of(new InternalUnknownExplanation());
        }
        return this.explainer.getMinimalConflict(this.chocoModel, background, relaxable);
    }
}

