/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalDiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalInconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalMissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.InternalUnknownExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.MissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.TestModelExpander;
import de.rwth.swc.coffee4j.algorithmic.conflict.UnknownConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class ConflictDetectionResultConverter {
    private final CompleteTestModel testModel;
    private final TestModelExpander expander;

    ConflictDetectionResultConverter(CompleteTestModel testModel, TestModelExpander expander) {
        Preconditions.notNull(testModel);
        Preconditions.notNull(expander);
        this.testModel = testModel;
        this.expander = expander;
    }

    MissingInvalidTuple convertMissingInvalidTuple(InternalMissingInvalidTuple internal) {
        int id = this.expander.computeOriginalId(internal.getNegatedErrorConstraintId());
        int[] parameters = internal.getInvolvedParameters();
        int[] values = internal.getMissingValues();
        ConflictExplanation explanation = this.convertExplanation(internal.getExplanation());
        return new MissingInvalidTuple(id, parameters, values, explanation);
    }

    private ConflictExplanation convertExplanation(InternalExplanation explanation) {
        if (explanation instanceof InternalConflictSet) {
            return this.convertConflictSet((InternalConflictSet)explanation);
        }
        if (explanation instanceof InternalInconsistentBackground) {
            return this.convertInconsistentBackground((InternalInconsistentBackground)explanation);
        }
        if (explanation instanceof InternalUnknownExplanation) {
            return this.convertUnknownExplanation();
        }
        if (explanation instanceof InternalDiagnosisSets) {
            return this.convertDiagnosisSets((InternalDiagnosisSets)explanation);
        }
        throw new IllegalStateException("unhandled ConflictExplanation subtype");
    }

    ConflictSet convertConflictSet(InternalConflictSet conflict) {
        List<ConflictElement> elements = Arrays.stream(conflict.getConflictSet()).mapToObj(this::convertConflictElement).collect(Collectors.toList());
        return new ConflictSet(elements);
    }

    ConflictElement convertConflictElement(int constraintId) {
        TupleList expandedTupleList = this.getExpandedTupleList(constraintId);
        return new ConflictElement(this.expander.computeOriginalId(constraintId), expandedTupleList.getInvolvedParameters(), expandedTupleList.getTuples().get(0));
    }

    InconsistentBackground convertInconsistentBackground(InternalInconsistentBackground inconsistentBackground) {
        List<ConflictElement> elements = Arrays.stream(inconsistentBackground.getBackground()).mapToObj(this::convertConflictElement).collect(Collectors.toList());
        return new InconsistentBackground(elements);
    }

    private UnknownConflictExplanation convertUnknownExplanation() {
        return new UnknownConflictExplanation();
    }

    DiagnosisSets convertDiagnosisSets(InternalDiagnosisSets diagnosis) {
        ConflictSet conflictSet = this.convertConflictSet(diagnosis.getRootConflictSet());
        List<DiagnosisSet> elements = Arrays.stream(diagnosis.getDiagnosisSets()).map(this::convertDiagnosisSet).collect(Collectors.toList());
        return new DiagnosisSets(conflictSet, elements);
    }

    DiagnosisSet convertDiagnosisSet(int[] diagnosisSet) {
        List<DiagnosisElement> elements = Arrays.stream(diagnosisSet).mapToObj(this::convertDiagnosisElement).collect(Collectors.toList());
        return new DiagnosisSet(elements);
    }

    DiagnosisElement convertDiagnosisElement(int constraintId) {
        TupleList expandedTupleList = this.getExpandedTupleList(constraintId);
        return new DiagnosisElement(this.expander.computeOriginalId(constraintId), expandedTupleList.getInvolvedParameters(), expandedTupleList.getTuples().get(0));
    }

    private TupleList getExpandedTupleList(int id) {
        Optional<TupleList> original = this.testModel.getExclusionTupleLists().stream().filter(tupleList -> tupleList.getId() == id).findFirst();
        return original.or(() -> this.testModel.getErrorTupleLists().stream().filter(tupleList -> tupleList.getId() == id).findFirst()).orElseThrow(() -> new IllegalStateException("unknown tuplelist with id " + id));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConflictDetectionResultConverter converter = (ConflictDetectionResultConverter)o;
        return this.testModel.equals(converter.testModel) && this.expander.equals(converter.expander);
    }

    public int hashCode() {
        return Objects.hash(this.testModel, this.expander);
    }

    public String toString() {
        return "ConflictDetectionResultConverter{testModel=" + this.testModel + ", expander=" + this.expander + "}";
    }
}

