/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class ConflictElement {
    private final int conflictingConstraintId;
    private final int[] involvedParameters;
    private final int[] conflictingValues;

    public ConflictElement(int conflictingConstraintId, int[] involvedParameters, int[] conflictingValues) {
        Preconditions.check(conflictingConstraintId > 0);
        Preconditions.notNull(involvedParameters);
        Preconditions.notNull(conflictingValues);
        this.conflictingConstraintId = conflictingConstraintId;
        this.involvedParameters = involvedParameters;
        this.conflictingValues = conflictingValues;
    }

    public int getConflictingConstraintId() {
        return this.conflictingConstraintId;
    }

    public int[] getConflictingValues() {
        return this.conflictingValues;
    }

    public int[] getInvolvedParameters() {
        return this.involvedParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConflictElement that = (ConflictElement)o;
        return this.conflictingConstraintId == that.conflictingConstraintId && Arrays.equals(this.conflictingValues, that.conflictingValues) && Arrays.equals(this.involvedParameters, that.involvedParameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.conflictingConstraintId);
        result = 31 * result + Arrays.hashCode(this.conflictingValues);
        result = 31 * result + Arrays.hashCode(this.involvedParameters);
        return result;
    }

    public String toString() {
        return "ConflictElement{conflictingConstraintId=" + this.conflictingConstraintId + ", conflictingValues=" + Arrays.toString(this.conflictingValues) + ", involvedParameters=" + Arrays.toString(this.involvedParameters) + "}";
    }
}

