/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class DiagnosisElement
implements Comparable<DiagnosisElement> {
    private final int diagnosedConstraintId;
    private final int[] involvedParameters;
    private final int[] conflictingValues;

    public DiagnosisElement(int diagnosedConstraintId, int[] involvedParameters, int[] conflictingValues) {
        Preconditions.check(diagnosedConstraintId > 0);
        Preconditions.notNull(involvedParameters);
        Preconditions.check(involvedParameters.length > 0);
        Preconditions.notNull(conflictingValues);
        Preconditions.check(conflictingValues.length > 0);
        this.diagnosedConstraintId = diagnosedConstraintId;
        this.involvedParameters = involvedParameters;
        this.conflictingValues = conflictingValues;
    }

    public int getDiagnosedConstraintId() {
        return this.diagnosedConstraintId;
    }

    public int[] getInvolvedParameters() {
        return this.involvedParameters;
    }

    public int[] getConflictingValues() {
        return this.conflictingValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosisElement that = (DiagnosisElement)o;
        return this.diagnosedConstraintId == that.diagnosedConstraintId && Arrays.equals(this.involvedParameters, that.involvedParameters) && Arrays.equals(this.conflictingValues, that.conflictingValues);
    }

    public int hashCode() {
        int result = Objects.hash(this.diagnosedConstraintId);
        result = 31 * result + Arrays.hashCode(this.involvedParameters);
        result = 31 * result + Arrays.hashCode(this.conflictingValues);
        return result;
    }

    public String toString() {
        return "DiagnosisElement{diagnosedConstraintId=" + this.diagnosedConstraintId + ", involvedParameters=" + Arrays.toString(this.involvedParameters) + ", conflictingValues=" + Arrays.toString(this.conflictingValues) + "}";
    }

    @Override
    public int compareTo(DiagnosisElement other) {
        int compare = Integer.compare(this.getDiagnosedConstraintId(), other.getDiagnosedConstraintId());
        if (compare == 0 && (compare = Arrays.compare(this.getInvolvedParameters(), other.getInvolvedParameters())) == 0) {
            compare = Arrays.compare(this.getConflictingValues(), other.getConflictingValues());
        }
        return compare;
    }
}

