/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisElement;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DiagnosisHittingSet {
    private final List<DiagnosisElement> diagnosisElements;

    public DiagnosisHittingSet(List<DiagnosisElement> diagnosisElements) {
        Preconditions.notNull(diagnosisElements);
        Preconditions.check(!diagnosisElements.isEmpty());
        Preconditions.check(this.containsNoDuplicates(diagnosisElements));
        this.diagnosisElements = new ArrayList<DiagnosisElement>(diagnosisElements);
        Collections.sort(this.diagnosisElements);
    }

    private boolean containsNoDuplicates(List<DiagnosisElement> diagnosisElements) {
        for (int i = 0; i < diagnosisElements.size(); ++i) {
            DiagnosisElement currentElement = diagnosisElements.get(i);
            for (int j = 0; j < diagnosisElements.size(); ++j) {
                DiagnosisElement otherElement = diagnosisElements.get(j);
                if (i == j || !currentElement.equals(otherElement)) continue;
                return false;
            }
        }
        return true;
    }

    public List<DiagnosisElement> getDiagnosisElements() {
        return this.diagnosisElements;
    }

    public boolean covers(DiagnosisHittingSet other) {
        Preconditions.notNull(other);
        return other.getDiagnosisElements().stream().allMatch(this::contains);
    }

    public boolean contains(DiagnosisElement otherElement) {
        Preconditions.notNull(otherElement);
        return this.diagnosisElements.stream().anyMatch(diagnosisElement -> diagnosisElement.equals(otherElement));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosisHittingSet that = (DiagnosisHittingSet)o;
        return this.diagnosisElements.equals(that.diagnosisElements);
    }

    public int hashCode() {
        return Objects.hash(this.diagnosisElements);
    }

    public String toString() {
        return "DiagnosisHittingSet{diagnosisElements=" + this.diagnosisElements + "}";
    }
}

