/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.conflict;

import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class MissingInvalidTuple {
    private final int negatedErrorConstraintId;
    private final int[] involvedParameters;
    private final int[] missingValues;
    private final ConflictExplanation explanation;

    public MissingInvalidTuple(int negatedErrorConstraintId, int[] involvedParameters, int[] missingValues, ConflictExplanation explanation) {
        Preconditions.check(negatedErrorConstraintId > 0);
        Preconditions.notNull(involvedParameters);
        Preconditions.notNull(missingValues);
        Preconditions.notNull(explanation);
        this.negatedErrorConstraintId = negatedErrorConstraintId;
        this.involvedParameters = involvedParameters;
        this.missingValues = missingValues;
        this.explanation = explanation;
    }

    public int getNegatedErrorConstraintId() {
        return this.negatedErrorConstraintId;
    }

    public int[] getInvolvedParameters() {
        return this.involvedParameters;
    }

    public int[] getMissingValues() {
        return this.missingValues;
    }

    public ConflictExplanation getExplanation() {
        return this.explanation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MissingInvalidTuple that = (MissingInvalidTuple)o;
        return this.negatedErrorConstraintId == that.negatedErrorConstraintId && Arrays.equals(this.involvedParameters, that.involvedParameters) && Arrays.equals(this.missingValues, that.missingValues) && this.explanation.equals(that.explanation);
    }

    public int hashCode() {
        int result = Objects.hash(this.negatedErrorConstraintId, this.explanation);
        result = 31 * result + Arrays.hashCode(this.involvedParameters);
        result = 31 * result + Arrays.hashCode(this.missingValues);
        return result;
    }

    public String toString() {
        return "MissingInvalidTuple{negatedErrorConstraintId=" + this.negatedErrorConstraintId + ", involvedParameters=" + Arrays.toString(this.involvedParameters) + ", missingValues=" + Arrays.toString(this.missingValues) + ", explanation=" + this.explanation + "}";
    }
}

